/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

public class SerialsUtil {
    public static int serialInt = 1;
    private static final DecimalFormat format8 = new DecimalFormat("00000000");
    private static final DecimalFormat format12 = new DecimalFormat("000000000000");
    private static final BigInteger divisor = BigInteger.valueOf(19999999L).multiply(BigInteger.valueOf(5L));
    private static final BigInteger divisor12 = BigInteger.valueOf(190000000097L).multiply(BigInteger.valueOf(5L));

    public static String genSerialNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String strNow = sdf.format(new Date());
        Random random = new Random();
        int intRandom = random.nextInt(999);
        String strRandom = String.valueOf(intRandom);
        int len = strRandom.length();
        int i = 0;
        while (i < 3 - len) {
            strRandom = "0" + strRandom;
            ++i;
        }
        String serialStr = SerialsUtil.nextSerial();
        return String.valueOf(strNow) + strRandom + serialStr;
    }

    public static synchronized String nextSerial() {
        int serial;
        if ((serial = serialInt++) > 999) {
            serialInt = 1;
            serial = 1;
        }
        String serialStr = String.valueOf(serial);
        int len = serialStr.length();
        int i = 0;
        while (i < 3 - len) {
            serialStr = "0" + serialStr;
            ++i;
        }
        return serialStr;
    }

    public static String randomNum12(long seed) {
        BigInteger dividend = BigDecimal.valueOf(seed).pow(5).toBigInteger();
        return format12.format(dividend.remainder(divisor12));
    }

    public static String randomNum8(long seed) {
        BigInteger dividend = BigDecimal.valueOf(seed).pow(5).toBigInteger();
        return format8.format(dividend.remainder(divisor));
    }

    public static String from10To32(String numStr, int size) {
        long to = 32L;
        long num = Long.parseLong(numStr);
        String jg = "";
        while (num != 0L) {
            switch (new Long(num % to).intValue()) {
                case 0: {
                    jg = "B" + jg;
                    break;
                }
                case 1: {
                    jg = "R" + jg;
                    break;
                }
                case 2: {
                    jg = "6" + jg;
                    break;
                }
                case 3: {
                    jg = "U" + jg;
                    break;
                }
                case 4: {
                    jg = "M" + jg;
                    break;
                }
                case 5: {
                    jg = "E" + jg;
                    break;
                }
                case 6: {
                    jg = "H" + jg;
                    break;
                }
                case 7: {
                    jg = "C" + jg;
                    break;
                }
                case 8: {
                    jg = "G" + jg;
                    break;
                }
                case 9: {
                    jg = "Q" + jg;
                    break;
                }
                case 10: {
                    jg = "A" + jg;
                    break;
                }
                case 11: {
                    jg = "8" + jg;
                    break;
                }
                case 12: {
                    jg = "3" + jg;
                    break;
                }
                case 13: {
                    jg = "S" + jg;
                    break;
                }
                case 14: {
                    jg = "J" + jg;
                    break;
                }
                case 15: {
                    jg = "Y" + jg;
                    break;
                }
                case 16: {
                    jg = "7" + jg;
                    break;
                }
                case 17: {
                    jg = "5" + jg;
                    break;
                }
                case 18: {
                    jg = "W" + jg;
                    break;
                }
                case 19: {
                    jg = "9" + jg;
                    break;
                }
                case 20: {
                    jg = "F" + jg;
                    break;
                }
                case 21: {
                    jg = "T" + jg;
                    break;
                }
                case 22: {
                    jg = "D" + jg;
                    break;
                }
                case 23: {
                    jg = "2" + jg;
                    break;
                }
                case 24: {
                    jg = "P" + jg;
                    break;
                }
                case 25: {
                    jg = "Z" + jg;
                    break;
                }
                case 26: {
                    jg = "N" + jg;
                    break;
                }
                case 27: {
                    jg = "K" + jg;
                    break;
                }
                case 28: {
                    jg = "V" + jg;
                    break;
                }
                case 29: {
                    jg = "X" + jg;
                    break;
                }
                case 30: {
                    jg = "L" + jg;
                    break;
                }
                case 31: {
                    jg = "4" + jg;
                    break;
                }
                default: {
                    jg = String.valueOf(String.valueOf(num % to)) + jg;
                }
            }
            num /= to;
        }
        if (jg.length() < size) {
            int loop = size - jg.length();
            int i = 0;
            while (i < loop) {
                jg = "2" + jg;
                ++i;
            }
        }
        return jg;
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        String str = uuid.toString();
        String temp = String.valueOf(str.substring(0, 8)) + str.substring(9, 13) + str.substring(14, 18) + str.substring(19, 23) + str.substring(24);
        return temp;
    }

    public static String generateShortUUID() {
        String str = SerialsUtil.randomNum8(System.nanoTime());
        return SerialsUtil.from10To32(str, 6);
    }

    public static String generateFileUUID() {
        String str = SerialsUtil.randomNum12(System.nanoTime());
        return SerialsUtil.from10To32(str, 8);
    }

    public static String genToken() {
        return String.valueOf(SerialsUtil.from10To32(SerialsUtil.randomNum12(System.currentTimeMillis()), 8)) + SerialsUtil.from10To32(SerialsUtil.randomNum12(System.nanoTime()), 8);
    }

    public static void main(String[] args) {
        System.out.println(SerialsUtil.genSerialNo());
    }
}

