/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PcsSkuStatusEnum {
    REJECT(2, "\u9a73\u56de"),
    UNSUBIMITTED(0, "\u8349\u7a3f"),
    CUSTOMS_REVIEW(5, "\u5173\u52a1\u5ba1\u6279"),
    LEGAL_REVIEW(1, "\u54c1\u7c7b\u7ecf\u7406\u5ba1\u6838"),
    FINANCE_REVIEW(3, "\u8d22\u52a1\u5ba1\u6838"),
    COMPLETED_REVIEW(9, "\u5ba1\u6838\u5b8c\u6210");

    public final Integer status;
    public final String desc;
    public static final List<PcsSkuStatusEnum> ALL;

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(PcsSkuStatusEnum.values()));
    }

    private PcsSkuStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static final List<Integer> statusListInTheReview() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(LEGAL_REVIEW.getStatus());
        list.add(PcsSkuStatusEnum.CUSTOMS_REVIEW.status);
        list.add(PcsSkuStatusEnum.FINANCE_REVIEW.status);
        return list;
    }

    public static final List<Map<String, Object>> listMapEnum() {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        PcsSkuStatusEnum[] pcsSkuStatusEnumArray = PcsSkuStatusEnum.values();
        int n = pcsSkuStatusEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PcsSkuStatusEnum skuStatusEnum = pcsSkuStatusEnumArray[n2];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", skuStatusEnum.status);
            map.put("name", skuStatusEnum.desc);
            listMap.add(map);
            ++n2;
        }
        return listMap;
    }

    public static String getDesc(int status) {
        for (PcsSkuStatusEnum c : ALL) {
            if (c.getStatus() != status) continue;
            return c.desc;
        }
        return null;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }
}

