package com.thebeastshop.pegasus.merchandise.vo;

import org.apache.commons.collections4.MapUtils;
import pers.richard.ormybatis.domain.core.AbstractDomain;

import java.util.Map;

public class PsLabelVO extends AbstractDomain {

	private Long labelId; //标签
	private String labelName;
    private String labelNameCN;

    public PsLabelVO() {}

    public PsLabelVO(Map map) {
    	this.labelId = MapUtils.getLong(map, "labelId");
		this.labelName= MapUtils.getString(map, "labelName");
		this.labelNameCN= MapUtils.getString(map, "labelNameCN");
    }

	public Long getLabelId() {
		return labelId;
	}

	public void setLabelId(Long labelId) {
		this.labelId = labelId;
	}

	public String getLabelName() {
		return labelName;
	}

	public void setLabelName(String labelName) {
		this.labelName = labelName;
	}

	public String getLabelNameCN() {
		return labelNameCN;
	}

	public void setLabelNameCN(String labelNameCN) {
		this.labelNameCN = labelNameCN;
	}

	/**
	 * 如果对象类型是User 的话 则返回true 去比较hashCode值
	 */
	@Override
	public boolean equals(Object obj) {
		if(obj == null) return false;
		if(this == obj) return true;
		if(obj instanceof PsLabelVO){
			PsLabelVO user =(PsLabelVO)obj;
//          if(user.id = this.id) return true; // 只比较id
			// 比较id 一致时才返回true 之后再去比较 hashCode
			if(user.labelId.longValue() == this.labelId.longValue()) return true;
		}
		return false;
	}



	/**
	 * 重写hashcode 方法，返回的hashCode 不一样才认定为不同的对象
	 */
	@Override
	public int hashCode() {
//      return id.hashCode(); // 只比较id，id一样就不添加进集合
		return labelId.hashCode();
	}
}
