package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * sku类型枚举
 * @author Gary
 *
 */
public enum PcsSkuTypeEnum {

	RAW_MATERIAL((short)1, "原材料"),
	SEMI_FINISHED_PRODUCT((short)2, "半成品"),
	FINISHED_PRODUCT((short)3, "成品");

	public final Short status;
	public final String desc;

	public static final List<PcsSkuTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PcsSkuTypeEnum(final Short status, final String desc) {
		this.status = status;
		this.desc = desc;
	}


	 // 普通方法
    public static String getDesc(Short status) {
		  if (status == null) {
        return  "";
			}
			for (PcsSkuTypeEnum c : ALL) {
					if (c.getStatus().equals(status)) {
							return c.desc;
					}
			}
			return null;
    }

	public Short getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}
}
