/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Roy.Chen
 * @version $Id: OpProductSkuCond.java, v 0.1 2015-08-14 17:13
 */
public class OpSpvVO implements Serializable {
    /**
     * ID
     */
    private Long id;
    private Long productId;


    private Integer canSale;
    private Integer canSee;

    private BigDecimal salesPrice;

    private BigDecimal discountPrice;

    /**
     * PRODUCT编码
     */
    private String productCode;
    /**
     * PRODUCT名称
     */
    private String productName;

    /**
     * 最小起售数
     */
    private Integer minAmount;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * SPV对应属性值JSON字符串
     */
    private String attrJSONText;

    /**
     *  SPV对应属性值文本Map [{AttrName -> AttrValueText}]
     */
    private List<Map<String, Object>> attrValueTextMap;

    /**
     * SPV对应属性值 {AttrId -> AttrValue}
     */
    private LinkedHashMap<Long, OpAttributeValueVO> attrValues;

    /**
     * SKU CODE
     */
    private String skuCode;

    private String skuName;


    private String attrValue1;
    private String attrValue2;
    private String attrValue3;
    private String spvImg;

    private String qualificationText;


    /**
     * 单品SKU
     */
    private PcsSkuVO skuVO;

    /**
     * SKU组合列表
     */
    private List<PcsSkuCombinationVO> skuCombinationList;

    public Integer getCanSee() {
        return canSee;
    }

    public void setCanSee(Integer canSee) {
        this.canSee = canSee;
    }

    public Integer getCanSale() {
        return canSale;
    }

    public void setCanSale(Integer canSale) {
        this.canSale = canSale;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }


    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

//    public boolean isCombined() {
//        return combined;
//    }

//    public void setCombined(boolean combined) {
//        this.combined = combined;
//    }

    public String getAttrJSONText() {
        return attrJSONText;
    }

    public void setAttrJSONText(String attrJSONText) {
        this.attrJSONText = attrJSONText;
    }

    public List<Map<String, Object>> getAttrValueTextMap() {
        return attrValueTextMap;
    }

    public void setAttrValueTextMap(List<Map<String, Object>> attrValueTextMap) {
        this.attrValueTextMap = attrValueTextMap;
    }

    public LinkedHashMap<Long, OpAttributeValueVO> getAttrValues() {
        return attrValues;
    }

    public void setAttrValues(LinkedHashMap<Long, OpAttributeValueVO> attrValues) {
        this.attrValues = attrValues;
    }

    public PcsSkuVO getSkuVO() {
        return skuVO;
    }

    public void setSkuVO(PcsSkuVO skuVO) {
        this.skuVO = skuVO;
    }

    public List<PcsSkuCombinationVO> getSkuCombinationList() {
        return skuCombinationList;
    }

    public void setSkuCombinationList(List<PcsSkuCombinationVO> skuCombinationList) {
        this.skuCombinationList = skuCombinationList;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public String getAttrValue1() {
        return attrValue1;
    }

    public void setAttrValue1(String attrValue1) {
        this.attrValue1 = attrValue1;
    }

    public String getAttrValue2() {
        return attrValue2;
    }

    public void setAttrValue2(String attrValue2) {
        this.attrValue2 = attrValue2;
    }

    public String getAttrValue3() {
        return attrValue3;
    }

    public void setAttrValue3(String attrValue3) {
        this.attrValue3 = attrValue3;
    }

    public String getSpvImg() {
        return spvImg;
    }

    public void setSpvImg(String spvImg) {
        this.spvImg = spvImg;
    }

    public String getQualificationText() {
        return qualificationText;
    }

    public void setQualificationText(String qualificationText) {
        this.qualificationText = qualificationText;
    }

    @Override
    public boolean equals(Object obj) {
        if(obj == null) return false;
        if(this == obj) return true;
        if(obj instanceof OpSpvVO){
            OpSpvVO user =(OpSpvVO)obj;
//          if(user.id = this.id) return true; // 只比较id
            // 比较id和username 一致时才返回true 之后再去比较 hashCode
            if(user.skuCode.equals(this.skuCode)) return true;
        }
        return false;
    }



    /**
     * 重写hashcode 方法，返回的hashCode 不一样才认定为不同的对象
     */
    @Override
    public int hashCode() {
//      return id.hashCode(); // 只比较id，id一样就不添加进集合
        return skuCode.hashCode();
    }

}
