package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class OpChannelVO implements Serializable {
    private Long id;
    /**
     * 渠道编码
     */
    private String code;

    // 用于接收前台传递，绑定业务线时使用
    private String channelCode;
    /**
     * 渠道名
     */
    private String name;
    /**
     * 渠道类型，1线下2线上
     */
    private Integer channelType;
    /**
     * 所属平台-1：线上、2：普通门店 3：Little B门店 4、其他
     */
    private Integer wayType;
    private String wayTypeStr;
    /**
     * 销售仓
     */
    private String warehouseForSales;

    private String warehouseForSalesName;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 售后电话
     */
    private String servicePhone;

    /**
     * 邮件通知地址
     * ‘；’分割
     */
    private String noticeEmails;

    private String warehouseForSalesOther;

    // 业务线
    private String serviceLineStr;

    private Integer serviceLine;

    List<OpChannelServiceLineVO> opChannelServiceLineVOs;

    List<Integer> serviceLineIds;

    public static final String REDIS_CHANNEL_CODE_WAY_TYPE = "CHANNEL_CODE_WAY_TYPE";

    public static final String REDIS_CHANNEL_NAME_WAY_TYPE = "CHANNEL_NAME_WAY_TYPE";

    public static final int REDIS_CHANNEL_DB_IDX = 0;

    private Integer type;

    public Integer getWayType() {
		return wayType;
	}

	public void setWayType(Integer wayType) {
		this.wayType = wayType;
	}

    public String getWayTypeStr() {
        return wayTypeStr;
    }

    public void setWayTypeStr(String wayTypeStr) {
        this.wayTypeStr = wayTypeStr;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public String getWarehouseForSales() {
        return warehouseForSales;
    }

    public void setWarehouseForSales(String warehouseForSales) {
        this.warehouseForSales = warehouseForSales;
    }

    public String getWarehouseForSalesName() {
        return warehouseForSalesName;
    }

    public void setWarehouseForSalesName(String warehouseForSalesName) {
        this.warehouseForSalesName = warehouseForSalesName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getNoticeEmails() {
        return noticeEmails;
    }

    public void setNoticeEmails(String noticeEmails) {
        this.noticeEmails = noticeEmails;
    }

    public String getWarehouseForSalesOther() {
        return warehouseForSalesOther;
    }

    public void setWarehouseForSalesOther(String warehouseForSalesOther) {
        this.warehouseForSalesOther = warehouseForSalesOther;
    }

    public String getServiceLineStr() {
        return serviceLineStr;
    }

    public void setServiceLineStr(String serviceLineStr) {
        this.serviceLineStr = serviceLineStr;
    }

    public Integer getServiceLine() {
        return serviceLine;
    }

    public void setServiceLine(Integer serviceLine) {
        this.serviceLine = serviceLine;
    }

    public List<OpChannelServiceLineVO> getOpChannelServiceLineVOs() {
        return opChannelServiceLineVOs;
    }

    public void setOpChannelServiceLineVOs(List<OpChannelServiceLineVO> opChannelServiceLineVOs) {
        this.opChannelServiceLineVOs = opChannelServiceLineVOs;
    }

    public List<Integer> getServiceLineIds() {
        return serviceLineIds;
    }

    public void setServiceLineIds(List<Integer> serviceLineIds) {
        this.serviceLineIds = serviceLineIds;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 如果对象类型是User 的话 则返回true 去比较hashCode值
     */
    @Override
    public boolean equals(Object obj) {
        if(obj == null) return false;
        if(this == obj) return true;
        if(obj instanceof OpChannelVO){
            OpChannelVO user =(OpChannelVO)obj;
//          if(user.id = this.id) return true; // 只比较id
            // 比较id和username 一致时才返回true 之后再去比较 hashCode
            if(user.id == this.id && user.name.equals(this.name)) return true;
        }
        return false;
    }



    /**
     * 重写hashcode 方法，返回的hashCode 不一样才认定为不同的对象
     */
    @Override
    public int hashCode() {
//      return id.hashCode(); // 只比较id，id一样就不添加进集合
        return id.hashCode() * name.hashCode();
    }
}