package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import java.io.Serializable;
import java.math.BigDecimal;

@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class PcsSkuConfigItemsDTO  implements Serializable {
    
    private static final long serialVersionUID = 6632179915157053134L;

    private Integer id;

    private String skuCode;


    @ExcelColumn(name="虚拟商品")
    private Boolean whetherLogistics;

    @ExcelColumn(name="是否物流配送")
    private BigDecimal averageLogisticsCosts;

    @ExcelColumn(name="平均物流运费（元）")
    private Boolean whetherVirtual;

    private Short installService;

    private String supplierTagFile;

    //供应商自带标签文件是否为图片
    private boolean supplierTagFileWhetherImg = true;

    public boolean getSupplierTagFileWhetherImg() {
        if (EmptyUtil.isNotEmpty(supplierTagFile) && supplierTagFile.indexOf(".pdf") != -1) {
            return  false;
        }
        return supplierTagFileWhetherImg;
    }

    public void setSupplierTagFileWhetherImg(boolean supplierTagFileWhetherImg) {
        this.supplierTagFileWhetherImg = supplierTagFileWhetherImg;
    }

    public Short getInstallService() {
        return installService;
    }

    public void setInstallService(Short installService) {
        this.installService = installService;
    }

    public String getSupplierTagFile() {
        return supplierTagFile;
    }

    public void setSupplierTagFile(String supplierTagFile) {
        this.supplierTagFile = supplierTagFile;
    }

    public Integer getId() {
        return id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.id
     *
     * @param id the value for t_pcs_sku_config_items.id
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.sku_code
     *
     * @return the value of t_pcs_sku_config_items.sku_code
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public String getSkuCode() {
        return skuCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.sku_code
     *
     * @param skuCode the value for t_pcs_sku_config_items.sku_code
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode == null ? null : skuCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.whether_logistics
     *
     * @return the value of t_pcs_sku_config_items.whether_logistics
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public Boolean getWhetherLogistics() {
        return whetherLogistics;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.whether_logistics
     *
     * @param whetherLogistics the value for t_pcs_sku_config_items.whether_logistics
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setWhetherLogistics(Boolean whetherLogistics) {
        this.whetherLogistics = whetherLogistics;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.average_logistics_costs
     *
     * @return the value of t_pcs_sku_config_items.average_logistics_costs
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public BigDecimal getAverageLogisticsCosts() {
        return averageLogisticsCosts;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.average_logistics_costs
     *
     * @param averageLogisticsCosts the value for t_pcs_sku_config_items.average_logistics_costs
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setAverageLogisticsCosts(BigDecimal averageLogisticsCosts) {
        this.averageLogisticsCosts = averageLogisticsCosts;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_sku_config_items.whether_virtual
     *
     * @return the value of t_pcs_sku_config_items.whether_virtual
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public Boolean getWhetherVirtual() {
        return whetherVirtual;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_sku_config_items.whether_virtual
     *
     * @param whetherVirtual the value for t_pcs_sku_config_items.whether_virtual
     *
     * @mbggenerated Mon Dec 04 15:59:38 CST 2017
     */
    public void setWhetherVirtual(Boolean whetherVirtual) {
        this.whetherVirtual = whetherVirtual;
    }
}