/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.pegasus.merchandise.vo.ChannelSelectorVO;
import com.thebeastshop.pegasus.merchandise.cond.OpChannelCond;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:26
 */
public interface McOpChannelService {

    @Transactional
    Long create(OpChannelVO channel);
    @Transactional
    boolean update(OpChannelVO channel);
    @Transactional
    boolean deleteById(Long id);

    OpChannelVO findById(Long id);

    /**
     * 根据条件查找渠道
     *
     * @param cond
     * @return 渠道列表
     */
    public List<OpChannelVO> findChannelByCond(String cond);

    /**
     * 条件查询 渠道
     *
     * @param cond
     * @return
     */
    List<OpChannelVO> findByCriteria(OpChannelCond cond);

    /**
     * 根据编码查找
     *
     * @param code
     * @return
     */
    OpChannelVO findByCode(String code);

    /**
     * 所有渠道
     *
     * @return
     */
    List<OpChannelVO> findAll();
    /**
     * 所有鲜花店
     *
     * @return
     */
    List<OpChannelVO> selectAllFlowerShops();
    
    
    List<OpChannelVO> findChannelByType(int type);

    /**
     * 根据渠道类型查找所有记录
     *
     * @param type
     *
     * @return
     */
    List<ChannelSelectorVO> findByChannelType(Integer type);
    
    /**
     * 根据渠道类型查找所有记录并放置redis
     *
     * @param cond
     *
     * @return
     */
    List<OpChannelVO> getChannelCodeByTypeToRedis(OpChannelCond cond);

    List<OpChannelVO> getIPOSChannels();

    Integer findChannelCityIdByCode(String channelCode);
}
