package com.thebeastshop.pegasus.merchandise.constants;

/**
 * SKU相关常量
 * @author gongjun
 */
public class PcsSkuConstants {

    // self
    // skuStatus
    /**
     * sku状态~价格待审核
     */
    public static final Integer SKU_STATUS_WAITING_VERIFY = 1;
    /**
     * sku状态~草稿
     */
    public static final Integer SKU_STATUS_DRAFT = 0;
    /**
     * sku状态~已驳回
     */
    public static final Integer SKU_STATUS_REJECT = 2;
    /**
     * sku状态~可用
     */
    public static final Integer SKU_STATUS_ABLE = 9;
    // skuType
    /**
     * sku类型~原材料
     */
    public static final Integer SKU_TYPE_MATERIAL = 1;
    /**
     * sku类型~半成品
     */
    public static final Integer SKU_TYPE_SEMIFINISHED_PRODUCT = 2;
    /**
     * sku类型~成品
     */
    public static final Integer SKU_TYPE_FINISHED_PRODUCT = 3;
    // serviceLevel
    /**
     * 产品重要性等级(1,2,3,4)
     */
    public static final Integer SERVICE_LEVEL_1 = 1;
    public static final Integer SERVICE_LEVEL_2 = 2;
    public static final Integer SERVICE_LEVEL_3 = 3;
    public static final Integer SERVICE_LEVEL_4 = 4;

}
