/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.cond;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCond.java, v 0.1 2015-08-03 16:44
 */
public class PcsSkuCond extends BaseQueryCond implements Serializable {

    /**
     * sku名
     */
    private String name;

    /**
     * sku中文名
     */
    private String nameCn;

    /**
     * skucode
     */
    private String code;

    /**
     * sku状态
     */
    private Integer skuStatus;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 品类名称
     */
    private String categoryName;
    private String categoryFullName;

    /**
     *  定制 SKU_CUSTOM_MADE_CODE 是否 null
     */
    private String skuCustomMade;
    /**
     *  组合 COMBINED_SKU_RECIPE_CODE 是否 null
     */
    private String combinedSkuRecipeCode;
    /**
     * 产品重要等级
     */
    private Integer serviceLevel;
    /**
     * 生命周期开始时间
     */
    private String saleStartDate;
    /**
     * 生命周期结束时间
     */
    private String saleEndDate;

    /**
     *采购员
     */
    private Long buyerId;
    /**
     * 是否跨境购
     */
    private Integer crossBorderFlag;

    /**
     * 当前登入人id
     */
    private String loginId;
    /**
     * 类型
     */
    private String skuType;
    /**
     * 是否提交：0没提交1已提交
     */
    private Integer isSubmit;
    /**
     * 审核状态：0取消1通过2特殊放行3未审核
     */
    private Integer checkStatus;

    
    private Integer hasImg; //是否有图片

    private Integer hasCustomize; //是否定制

    private Integer customizeType; // 定制类型


    private Integer  currentUserId;
    
    private Integer isImported; //是否进口
    
    // 是否自进口
    private Integer isOwnImported;
    // 资质审批状态
    private Integer qualifyAuditStatus;
    // 资质审批流程
    private Integer qualifyFlowTrend;
    // 资质审批ID
    private Long qualifyId;
    // 资质文件是否需要后补
    private Integer isPostMeeting;
    // 资质文件到期时间
    private Date qualifyExpireDate;
    // 资质文件证书编号
    private Date qualifyCode;

    private List<Integer> qualifyAuditStatusList;
    private List<Integer> qualifyFlowTrendList;
    private List<Integer> auditDecisionList;

    private Date tagLastUpdateTime;//标签最近更新时间
    
    private String poCode;//采购单号
    
    private String editedTagStatus;//是否已编辑标签
    
    private Long categoryManager;//品类经理
    
    
    private String isImgUrl;//供应商图片是否上传
    
    private Integer isHasTag;//供应商是否提供图片
    
    
    private String ids;

    // 文件数量
    private Integer fileCount;

    //sku多状态查询
    private Integer[] skuStatusArr;
   
    private String sortField = "a.ID";

    private String sortType = "desc";

    private Long buyerLoginId;

    /**
     * PO、PJ创建开始时间
     */
    private String skuCreateTimeBegin;
    /**
     * PO、PJ创建结束时间
     */
    private String skuCreateTimeEnd;
    
    /**
     * PO、PJ收货开始时间
     */
    private String skuDeliveryTimeBegin;
    /**
     * PO、PJ收货结束时间
     */
    private String skuDeliveryTimeEnd;
    /**
     * 材质
     */
    private String skuMaterial;
    /**
     * 品类ID
     */
    private Integer categoryId;
    
	public Integer getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Integer categoryId) {
		this.categoryId = categoryId;
	}

	public String getSkuCreateTimeBegin() {
		return skuCreateTimeBegin;
	}

	public void setSkuCreateTimeBegin(String skuCreateTimeBegin) {
		this.skuCreateTimeBegin = skuCreateTimeBegin;
	}

	public String getSkuCreateTimeEnd() {
		return skuCreateTimeEnd;
	}

	public void setSkuCreateTimeEnd(String skuCreateTimeEnd) {
		this.skuCreateTimeEnd = skuCreateTimeEnd;
	}

	public String getSkuDeliveryTimeBegin() {
		return skuDeliveryTimeBegin;
	}

	public void setSkuDeliveryTimeBegin(String skuDeliveryTimeBegin) {
		this.skuDeliveryTimeBegin = skuDeliveryTimeBegin;
	}

	public String getSkuDeliveryTimeEnd() {
		return skuDeliveryTimeEnd;
	}

	public void setSkuDeliveryTimeEnd(String skuDeliveryTimeEnd) {
		this.skuDeliveryTimeEnd = skuDeliveryTimeEnd;
	}

	public String getSkuMaterial() {
		return skuMaterial;
	}

	public void setSkuMaterial(String skuMaterial) {
		this.skuMaterial = skuMaterial;
	}

	public Long getBuyerLoginId() {
		return buyerLoginId;
	}

	public void setBuyerLoginId(Long buyerLoginId) {
		this.buyerLoginId = buyerLoginId;
	}

	public String getSortField() {
		return sortField;
	}

	public void setSortField(String sortField) {
		this.sortField = sortField;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public Integer[] getSkuStatusArr() {
		return skuStatusArr;
	}

	public void setSkuStatusArr(Integer[] skuStatusArr) {
		this.skuStatusArr = skuStatusArr;
	}

	public String getIds() {
		return ids;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}

	public Long getCategoryManager() {
		return categoryManager;
	}

	public void setCategoryManager(Long categoryManager) {
		this.categoryManager = categoryManager;
	}

	public Integer getCurrentUserId() {
		return currentUserId;
	}

	public void setCurrentUserId(Integer currentUserId) {
		this.currentUserId = currentUserId;
	}

	public Integer getHasImg() {
		return hasImg;
	}

	public void setHasImg(Integer hasImg) {
		this.hasImg = hasImg;
	}

	public String getLoginId() {
        return loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public String getSkuCustomMade() {
        return StringUtils.isBlank(skuCustomMade)?null:skuCustomMade;
    }

    public void setSkuCustomMade(String skuCustomMade) {
        this.skuCustomMade = skuCustomMade;
    }

    public String getCombinedSkuRecipeCode() {
        return StringUtils.isBlank(combinedSkuRecipeCode)?null:combinedSkuRecipeCode;
    }

    public void setCombinedSkuRecipeCode(String combinedSkuRecipeCode) {
        this.combinedSkuRecipeCode = combinedSkuRecipeCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getSkuStatus() {
        return skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Integer getServiceLevel() {
        return serviceLevel;
    }

    public void setServiceLevel(Integer serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public String getSaleStartDate() {
        return saleStartDate;
    }

    public void setSaleStartDate(String saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public String getSaleEndDate() {
        return saleEndDate;
    }

    public void setSaleEndDate(String saleEndDate) {
        this.saleEndDate = saleEndDate;
    }

    public String getSkuType() {
        return skuType;
    }

    public void setSkuType(String skuType) {
        this.skuType = skuType;
    }

    public Integer getIsSubmit() {
        return isSubmit;
    }

    @Override
	public String toString() {
		return "PcsSkuCond [name=" + name + ", nameCn=" + nameCn + ", code=" + code + ", skuStatus=" + skuStatus
				+ ", supplierName=" + supplierName + ", brandName=" + brandName + ", categoryName=" + categoryName
				+ ", categoryFullName=" + categoryFullName + ", skuCustomMade=" + skuCustomMade
				+ ", combinedSkuRecipeCode=" + combinedSkuRecipeCode + ", serviceLevel=" + serviceLevel
				+ ", saleStartDate=" + saleStartDate + ", saleEndDate=" + saleEndDate + ", buyerId=" + buyerId
				+ ", crossBorderFlag=" + crossBorderFlag + ", loginId=" + loginId + ", skuType=" + skuType
				+ ", isSubmit=" + isSubmit + ", checkStatus=" + checkStatus + ", hasImg=" + hasImg + ", hasCustomize="
				+ hasCustomize + ", customizeType=" + customizeType + ", currentUserId=" + currentUserId
				+ ", isImported=" + isImported + ", isOwnImported=" + isOwnImported + ", qualifyAuditStatus="
				+ qualifyAuditStatus + ", qualifyFlowTrend=" + qualifyFlowTrend + ", qualifyId=" + qualifyId
				+ ", isPostMeeting=" + isPostMeeting + ", qualifyExpireDate=" + qualifyExpireDate + ", qualifyCode="
				+ qualifyCode + ", qualifyAuditStatusList=" + qualifyAuditStatusList + ", qualifyFlowTrendList="
				+ qualifyFlowTrendList + ", auditDecisionList=" + auditDecisionList + ", tagLastUpdateTime="
				+ tagLastUpdateTime + ", poCode=" + poCode + ", editedTagStatus=" + editedTagStatus
				+ ", categoryManager=" + categoryManager + ", isImgUrl=" + isImgUrl + ", isHasTag=" + isHasTag
				+ ", ids=" + ids + ", fileCount=" + fileCount + ", skuStatusArr=" + Arrays.toString(skuStatusArr)
				+ ", sortField=" + sortField + ", sortType=" + sortType + ", buyerLoginId=" + buyerLoginId
				+ ", skuCreateTimeBegin=" + skuCreateTimeBegin + ", skuCreateTimeEnd=" + skuCreateTimeEnd
				+ ", skuDeliveryTimeBegin=" + skuDeliveryTimeBegin + ", skuDeliveryTimeEnd=" + skuDeliveryTimeEnd
				+ ", skuMaterial=" + skuMaterial + ", categoryId=" + categoryId + "]";
	}

	public void setIsSubmit(Integer isSubmit) {
        this.isSubmit = isSubmit;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getCategoryFullName() {
        return categoryFullName;
    }

    public void setCategoryFullName(String categoryFullName) {
        this.categoryFullName = categoryFullName;
    }

	public Integer getIsImported() {
		return isImported;
	}

	public void setIsImported(Integer isImported) {
		this.isImported = isImported;
	}

	public Date getTagLastUpdateTime() {
		return tagLastUpdateTime;
	}

	public void setTagLastUpdateTime(Date tagLastUpdateTime) {
		this.tagLastUpdateTime = tagLastUpdateTime;
	}

	public String getPoCode() {
		return poCode;
	}

	public void setPoCode(String poCode) {
		this.poCode = poCode;
	}

	public String getEditedTagStatus() {
		return editedTagStatus;
	}

	public void setEditedTagStatus(String editedTagStatus) {
		this.editedTagStatus = editedTagStatus;
	}

	public String getIsImgUrl() {
		return isImgUrl;
	}

	public void setIsImgUrl(String isImgUrl) {
		this.isImgUrl = isImgUrl;
	}

	public Integer getIsHasTag() {
		return isHasTag;
	}

	public void setIsHasTag(Integer isHasTag) {
		this.isHasTag = isHasTag;
	}

	public Integer getIsOwnImported() {
		return isOwnImported;
	}
    public Integer getHasCustomize() {
        return hasCustomize;
    }

    public void setHasCustomize(Integer hasCustomize) {
        this.hasCustomize = hasCustomize;
    }

    public Integer getCustomizeType() {
        return customizeType;
    }

    public void setCustomizeType(Integer customizeType) {
        this.customizeType = customizeType;
    }
	public void setIsOwnImported(Integer isOwnImported) {
		this.isOwnImported = isOwnImported;
	}

	public Integer getQualifyAuditStatus() {
		return qualifyAuditStatus;
	}

	public void setQualifyAuditStatus(Integer qualifyAuditStatus) {
		this.qualifyAuditStatus = qualifyAuditStatus;
	}

	public Integer getQualifyFlowTrend() {
		return qualifyFlowTrend;
	}

	public void setQualifyFlowTrend(Integer qualifyFlowTrend) {
		this.qualifyFlowTrend = qualifyFlowTrend;
	}

	public Long getQualifyId() {
		return qualifyId;
	}

	public void setQualifyId(Long qualifyId) {
		this.qualifyId = qualifyId;
	}

	public Integer getIsPostMeeting() {
		return isPostMeeting;
	}

	public void setIsPostMeeting(Integer isPostMeeting) {
		this.isPostMeeting = isPostMeeting;
	}

	public Date getQualifyExpireDate() {
		return qualifyExpireDate;
	}

	public void setQualifyExpireDate(Date qualifyExpireDate) {
		this.qualifyExpireDate = qualifyExpireDate;
	}

	public Date getQualifyCode() {
		return qualifyCode;
	}

	public void setQualifyCode(Date qualifyCode) {
		this.qualifyCode = qualifyCode;
	}

	public List<Integer> getQualifyAuditStatusList() {
		return qualifyAuditStatusList;
	}

	public void setQualifyAuditStatusList(List<Integer> qualifyAuditStatusList) {
		this.qualifyAuditStatusList = qualifyAuditStatusList;
	}

	public List<Integer> getQualifyFlowTrendList() {
		return qualifyFlowTrendList;
	}

	public void setQualifyFlowTrendList(List<Integer> qualifyFlowTrendList) {
		this.qualifyFlowTrendList = qualifyFlowTrendList;
	}

	public List<Integer> getAuditDecisionList() {
		return auditDecisionList;
	}

	public void setAuditDecisionList(List<Integer> auditDecisionList) {
		this.auditDecisionList = auditDecisionList;
	}

    public Integer getFileCount() { return fileCount; }

    public void setFileCount(Integer fileCount) { this.fileCount = fileCount; }
}
