package com.thebeastshop.pegasus.merchandise.vo;

import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.NotNull;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * sku属性excel导入批量设置
 * @author Gary
 * @date 2017-05-09 
 */
@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class OpSkuAttributeSetupExcel {
  
	@NotNull
	@ExcelColumn(name = "skucode")
	private String skuCode;
	
	@NotNull
	@ExcelColumn(name = "属性名")
	private String attributeName;
	
	@NotNull
	@ExcelColumn(name = "属性值")
	private String attributeVals;
	
	 
	private List<String> attributeValList;


	public String getSkuCode() {
		return skuCode;
	}


	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}


	public String getAttributeName() {
		return attributeName;
	}


	public void setAttributeName(String attributeName) {
		this.attributeName = attributeName;
	}


	public String getAttributeVals() {
		return attributeVals;
	}


	public void setAttributeVals(String attributeVals) {
		this.attributeVals = attributeVals;
	}


	public List<String> getAttributeValList() {
		attributeValList = new ArrayList<String>();
		if(attributeVals != null) {
			String[] attributeArray = attributeVals.split(",");
			for(String attributeVal : attributeArray) {
				attributeValList.add(attributeVal);
			}
		}
		return attributeValList;
	}


	public void setAttributeValList(List<String> attributeValList) {
		this.attributeValList = attributeValList;
	}
	
	
}
