package com.thebeastshop.pegasus.merchandise.vo;


import java.io.Serializable;
import java.util.Date;

public class OpChannelVO implements Serializable {
    private Long id;
    /**
     * 渠道编码
     */
    private String code;
    /**
     * 渠道名
     */
    private String name;
    /**
     * 渠道类型，1线下2线上
     */
    private Integer channelType;
    /**
     * 销售仓
     */
    private String warehouseForSales;

    private String warehouseForSalesName;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 售后电话
     */
    private String servicePhone;

    /**
     * 邮件通知地址
     * ‘；’分割
     */
    private String noticeEmails;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public String getWarehouseForSales() {
        return warehouseForSales;
    }

    public void setWarehouseForSales(String warehouseForSales) {
        this.warehouseForSales = warehouseForSales;
    }

    public String getWarehouseForSalesName() {
        return warehouseForSalesName;
    }

    public void setWarehouseForSalesName(String warehouseForSalesName) {
        this.warehouseForSalesName = warehouseForSalesName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getNoticeEmails() {
        return noticeEmails;
    }

    public void setNoticeEmails(String noticeEmails) {
        this.noticeEmails = noticeEmails;
    }

    /**
     * 如果对象类型是User 的话 则返回true 去比较hashCode值
     */
    @Override
    public boolean equals(Object obj) {
        if(obj == null) return false;
        if(this == obj) return true;
        if(obj instanceof OpChannelVO){
            OpChannelVO user =(OpChannelVO)obj;
//          if(user.id = this.id) return true; // 只比较id
            // 比较id和username 一致时才返回true 之后再去比较 hashCode
            if(user.id == this.id && user.name.equals(this.name)) return true;
        }
        return false;
    }



    /**
     * 重写hashcode 方法，返回的hashCode 不一样才认定为不同的对象
     */
    @Override
    public int hashCode() {
//      return id.hashCode(); // 只比较id，id一样就不添加进集合
        return id.hashCode() * name.hashCode();
    }
}