package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailsInsertVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailsSaveVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmDetailsVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;

import java.util.List;

public interface McOpProdDynmcontDetailsService {
    
	/**
	 * 通过商品code查询redis缓存动态内容数据
	 * @param productCode
	 * @return
	 */
	OpProdDynmDetailsSaveVO getByProductCode(String productCode);
    
	List<OpProdDynmDetailsVO> findByProdId(Long prodId);
	
	/**
	 * 根据prodId查询SKUCODE
	 * @param prodId
	 * @return
	 */
	List<ProdSkuVO> findProdSkuByProdId(Long prodId);
	
	/**
	 * 批量导入动态内容
	 * @param prodId
	 * @return
	 */
	void saveByProdCodeAndTypeNew(String prodCode,Integer productId, String content, Integer contentTypeIndex);
	
	/**
	 * 是否编辑过新版
	 * @param productCode
	 * @return
	 */
	boolean IsEditByProdCode(String productCode);


	Integer batchUpdateProd (List<OpProdDynmDetailsInsertVO> opProdDynmDetails,OpProdDynmDetailsSaveVO opProdDynmDetailsSaveVO);

	Integer batchDeleteByProdId (Integer prodId);

}
