/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.vo.PsBaseVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import java.util.Date;
import java.util.List;

public class PsCampaignVO
extends PsBaseVO {
    private Long id;
    private String code;
    private String name;
    private String title;
    private Integer state;
    private Integer productScopeId;
    private Integer discountTypeId;
    private String discountTypeName;
    private Integer crossBorderFlag;
    private List<Integer> accessWayIds;
    private List<Integer> memberLevels;
    private transient byte[] accessWayArray = new byte[16];
    private transient byte[] memberLevelArray = new byte[16];
    private List<PsCampaignSectionVO> campaignSectionList;
    private Integer cumulative;
    private Date createTime;
    private Date startTime;
    private Date expireTime;
    private Integer approvalState;
    private Integer advance;
    private String advanceName;
    private String advanceTitle;
    private Date advanceStartTime;
    private Date advanceEndTime;
    private String advancePriceTitle;
    private Integer limitAmount;
    private Integer optionFlag;
    private Integer ladderRule;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getProductScopeId() {
        return this.productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public Integer getDiscountTypeId() {
        return this.discountTypeId;
    }

    public void setDiscountTypeId(Integer discountTypeId) {
        this.discountTypeId = discountTypeId;
    }

    public String getDiscountTypeName() {
        return this.discountTypeName;
    }

    public void setDiscountTypeName(String discountTypeName) {
        this.discountTypeName = discountTypeName;
    }

    public Integer getCrossBorderFlag() {
        return this.crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public List<Integer> getAccessWayIds() {
        return this.accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
        if (accessWayIds != null) {
            for (int index : accessWayIds) {
                if (index < 0 || index > 9) continue;
                this.accessWayArray[index] = 1;
            }
        }
    }

    public List<Integer> getMemberLevels() {
        return this.memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
        if (memberLevels != null) {
            for (int index : memberLevels) {
                if (index < -1 || index > 8) continue;
                this.memberLevelArray[index + 1] = 1;
            }
        }
    }

    public Boolean match(Integer accessWay, Integer memberLevel, Boolean crossBorderFlag) {
        Date now;
        if (accessWay > 9 || accessWay < 0 || memberLevel > 8 || memberLevel < -1) {
            return false;
        }
        if (this.state == null || !this.state.equals(1)) {
            return false;
        }
        if (this.startTime != null && this.expireTime != null && ((now = new Date()).before(this.startTime) || now.after(this.expireTime))) {
            return false;
        }
        if (this.crossBorderFlag != null && this.crossBorderFlag.equals(1) && !crossBorderFlag.booleanValue()) {
            return false;
        }
        if ((this.crossBorderFlag == null || this.crossBorderFlag.equals(0)) && crossBorderFlag.booleanValue()) {
            return false;
        }
        if (this.accessWayArray[accessWay] == 0) {
            return false;
        }
        if (this.memberLevelArray[memberLevel + 1] == 0) {
            return false;
        }
        return true;
    }

    public Boolean isMatchAdvance(Integer accessWay, Integer memberLevel, Boolean crossBorder) {
        Date now;
        if (accessWay > 9 || accessWay < 0 || memberLevel > 8 || memberLevel < -1) {
            return false;
        }
        if (this.advance == null || this.advance != 1) {
            return false;
        }
        if (this.state == null || !this.state.equals(1)) {
            return false;
        }
        if (this.accessWayArray[accessWay] == 0) {
            return false;
        }
        if (this.memberLevelArray[memberLevel + 1] == 0) {
            return false;
        }
        if (this.advanceStartTime != null && this.advanceEndTime != null && ((now = new Date()).before(this.advanceStartTime) || now.after(this.advanceEndTime))) {
            return false;
        }
        if (this.crossBorderFlag != null && this.crossBorderFlag.equals(1) && !crossBorder.booleanValue()) {
            return false;
        }
        if ((this.crossBorderFlag == null || this.crossBorderFlag.equals(0)) && crossBorder.booleanValue()) {
            return false;
        }
        return true;
    }

    public List<PsCampaignSectionVO> getCampaignSectionList() {
        return this.campaignSectionList;
    }

    public void setCampaignSectionList(List<PsCampaignSectionVO> campaignSectionList) {
        this.campaignSectionList = campaignSectionList;
    }

    public Integer getCumulative() {
        return this.cumulative;
    }

    public void setCumulative(Integer cumulative) {
        this.cumulative = cumulative;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getApprovalState() {
        return this.approvalState;
    }

    public void setApprovalState(Integer approvalState) {
        this.approvalState = approvalState;
    }

    public Integer getAdvance() {
        return this.advance;
    }

    public void setAdvance(Integer advance) {
        this.advance = advance;
    }

    public String getAdvanceName() {
        return this.advanceName;
    }

    public void setAdvanceName(String advanceName) {
        this.advanceName = advanceName;
    }

    public String getAdvanceTitle() {
        return this.advanceTitle;
    }

    public void setAdvanceTitle(String advanceTitle) {
        this.advanceTitle = advanceTitle;
    }

    public Date getAdvanceStartTime() {
        return this.advanceStartTime;
    }

    public void setAdvanceStartTime(Date advanceStartTime) {
        this.advanceStartTime = advanceStartTime;
    }

    public Date getAdvanceEndTime() {
        return this.advanceEndTime;
    }

    public void setAdvanceEndTime(Date advanceEndTime) {
        this.advanceEndTime = advanceEndTime;
    }

    public String getAdvancePriceTitle() {
        return this.advancePriceTitle;
    }

    public void setAdvancePriceTitle(String advancePriceTitle) {
        this.advancePriceTitle = advancePriceTitle;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PsCampaignVO) {
            PsCampaignVO that = (PsCampaignVO)((Object)obj);
            return this.id != null && this.id.equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Integer getLimitAmount() {
        return this.limitAmount;
    }

    public void setLimitAmount(Integer limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Integer getOptionFlag() {
        return this.optionFlag;
    }

    public void setOptionFlag(Integer optionFlag) {
        this.optionFlag = optionFlag;
    }

    public Integer getLadderRule() {
        return this.ladderRule;
    }

    public void setLadderRule(Integer ladderRule) {
        this.ladderRule = ladderRule;
    }
}

