package com.thebeastshop.pegasus.merchandise.vo;

import java.util.Date;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.ProductUpDownRecord;
import com.thebeastshop.scm.po.ProductUpDownTimer;

/**
 * 单个PROD上下架操作VO
 * @author donghui
 */
public class ProdUpDownOperVO extends AbstractDomain{
	private Integer canSaleProdId;//t_op_chn_can_sale_prod表的id
	private Integer onShelf;
	private String reason;
	private Date timerOperTime;//定时上下架时间
	private Integer createUserId;
	private String createUserName;
	
	public ProdUpDownOperVO(){}
	
	public ProductUpDownRecord toProdctUpDownRecord() {
		ProductUpDownRecord  opProdctUpDownRecord = new ProductUpDownRecord();
		opProdctUpDownRecord.setOpChnCanSaleProdId((int)this.canSaleProdId);
		opProdctUpDownRecord.setDownReason(this.reason);
		opProdctUpDownRecord.setIsTimer("0");
		opProdctUpDownRecord.setCreateAt(new Date());
		opProdctUpDownRecord.setCreateUserId(this.createUserId);
		opProdctUpDownRecord.setCreateUserName(this.createUserName);
		if (onShelf == 0) {//下架
			opProdctUpDownRecord.setStatus(ProductUpDownRecord.Status.DOWN.toString());
		} else if(onShelf == 1) {//上架
			opProdctUpDownRecord.setStatus(ProductUpDownRecord.Status.UP.toString());
		}
		return opProdctUpDownRecord;
	}
	
	public ProductUpDownTimer toOpProductUpDownTimer() {
		ProductUpDownTimer opProductUpDownTimer = new ProductUpDownTimer();
		opProductUpDownTimer.setOpChnCanSaleProdId(this.canSaleProdId);
		opProductUpDownTimer.setTimerOperTime(this.timerOperTime);
		opProductUpDownTimer.setReason(this.reason);
		if (onShelf == 0) {//下架
			opProductUpDownTimer.setStatus(ProductUpDownRecord.Status.DOWN.toString());
		} else if(onShelf == 1) {//上架
			opProductUpDownTimer.setStatus(ProductUpDownRecord.Status.UP.toString());
		}
		return opProductUpDownTimer;
	}
	
	public Integer getCanSaleProdId() {return canSaleProdId;}
	public void setCanSaleProdId(Integer canSaleProdId) {this.canSaleProdId = canSaleProdId;}
	
	public Integer getOnShelf() {return onShelf;}
	public void setOnShelf(Integer onShelf) {this.onShelf = onShelf;}
	
	public String getReason() {return reason;}
	public void setReason(String reason) {this.reason = reason;}
	
	public Date getTimerOperTime() {return timerOperTime;}
	public void setTimerOperTime(Date timerOperTime) {this.timerOperTime = timerOperTime;}
	
	public Integer getCreateUserId() {return createUserId;}
	public void setCreateUserId(Integer createUserId) {this.createUserId = createUserId;}

	public String getCreateUserName() {return createUserName;}
	public void setCreateUserName(String createUserName) {this.createUserName = createUserName;}
}
