package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.pegasus.merchandise.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface McPcsBuyerInfoService {

    /**
     * 根据id获取采购详情
     * @return
     */
    PcsBuyerInfoVO getBuyerInfoById(Long id);

    /**
     * 获取所有采购员信息
     * @return
     */
    List<PcsBuyerInfoVO> getAllBuyers();

    /**
     * 采购员id与姓名对应列表
     * @return
     */
    List<Map<String,String>> getAllBuyerInfos();

    /**
     * 条件查询采购员信息
     * @param cond
     * @return
     */
    List<PcsBuyerInfoVO> getBuyerByCond(PcsBuyerCond cond);

    /**
     * 新建采购员
     * @param buyerInfo
     * @return
     */
    @Transactional
    Boolean newBuyer(PcsBuyerInfoVO buyerInfo);

    /**
     * 更新采购员信息
     * @param buyer
     * @return
     */
    @Transactional
    Boolean updateBuyerInfo(PcsBuyerInfoVO buyer);

    /**
     * 禁用采购员
     * */
    @Transactional
    boolean disableBuyerById(Long buyerId);
    
    UserInfo findCategoryManagerByBuyer(Integer buyerId);
    
    List<Integer> addPurchaseCategoryPermission(Integer userId, List<String> categoryList);
    
    List<Integer> addBusinessCategoryPermission(Integer userId, List<String> categoryList);
}
