package com.thebeastshop.pegasus.merchandise.exception;

/**
 * 权益异常枚举
 * @Class Name InterestExceptionErrorEnum
 * @Author Xiang.Gao
 * @Create In 2017-3-7
 */
public enum InterestExceptionEnum {

	ERROR_PARAM_NULL("IT0001","参数为空"), 
	ERROR_PARAM_MISS("IT0002","参数缺失"),
	ERROR_NOT_FOUND("IT0003","未能找到权益商品"), 
	ERROR_CASH_SPOCE("IT0004","不在兑取时间范围内"),
	ERROR_CASH_EXCESS("IT0005","兑取商品数量超额"), 
	ERROR_CASH_EXCEED("IT0006","请设置有效的兑取时间"),
	ERROR_RECEIVE_SPOCE("IT0007","不在领取时间范围内"),
	ERROR_SKU_NO_STOCK("IT0008","商品库存不足"),
	ERROR_BACK_EXCESS("IT0009","返还权益数量超额"),
	ERROR_INSERT_DB("IT0100","新增数据失败"),
	ERROR_SAVE_INTEREST("IT0101","保存权益失败"),
	ERROR_SAVE_INTEREST_SKU("IT0102","保存权益SKU失败"),
	ERROR_PROVIDE_INTEREST("IT0103","权益发放失败"),
	ERROR_UPDATE_DB("IT0200","更新数据失败"),
	ERROR_UPDATE_EXCESS("IT0201","更新权益兑取数量失败"),
	ERROR_UPDATE_STATUS("IT0202","更新用户兑取状态失败"),
	ERROR_UPDATE_RECEIVE("IT0203","更新权益领取数量失败"),
	ERROR_UPDATE_CHANGE("IT0204","商品权益互换SKU失败"),
	ERROR_DELETE_DB("IT0300","删除数据失败"),
	ERROR_DELETE_INTEREST("IT0301","删除权益失败"),
	ERROR_DELETE_INTEREST_SKU("IT0302","删除权益SKU失败"),
	ERROR_SEARCH_DB("IT0400","数据查询异常");
	
	private String errCode;
	
	private String errMsg;
	
	private InterestExceptionEnum(String errCode, String errMsg) {
		this.errCode = errCode;
		this.errMsg = errMsg;
	}
	
	public static String getErrMsg(String errCode) {
		for (InterestExceptionEnum e : InterestExceptionEnum.values()) {
			if(e.getErrCode().equals(errCode)) {
				return e.getErrMsg();
			}
		}
		return null;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getErrMsg() {
		return errMsg;
	}

	public void setErrMsg(String errMsg) {
		this.errMsg = errMsg;
	}
	
}
