package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Sku审核状态
 * @author Gary
 *
 */
public enum PcsSkuSalesPriceChangeStatusEnum {
	
	LEGAL_REVIEW(1, "待品类经理审批"),
	FINANCE_REVIEW(4, "待财务审批"),
	COMPLETED_REVIEW(2, "审核完成"),
	REJECT(3, "驳回");
	
	private final Integer status;
	
	private final String desc;
	
	PcsSkuSalesPriceChangeStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

	
	
	public static final List<PcsSkuSalesPriceChangeStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	

	 // 普通方法
    public static String getDesc(int status) {
        for (PcsSkuSalesPriceChangeStatusEnum c : PcsSkuSalesPriceChangeStatusEnum .values()) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }
}
