package com.thebeastshop.pegasus.merchandise.cond;

import java.io.Serializable;
import java.util.List;

/**
 * @author Lk
 * @since 2016-08-29
 */
public class ProdSearchCond implements Serializable {
    /**
     * 渠道号
     */
    private String channelCode;
    /**
     * 类目Id列表
     */
    private List<String> categoryCodes;
    /**
     * 是否新上架(0:不用上架 1：上架)
     */
    private Boolean isNew;
    /**
     * 新上架时间范围
     */
    private DateRange dateRange;
    /**
     * 【分页】从第几个开始
     */
    private Integer from;
    /**
     * 【分页】每次查询几个
     */
    private Integer size;
    /**
     * create_time 按上架时间
     * price 按价格
     */
    private String sortField;
    /**
     * ASC 升序
     * DESC 降序
     */
    private String sortOrder;
    /**
     * 关键字模糊查询
     */
    private String Keywords;
    /**
     * 是否是海淘商品(1：是 0：否)C
     */
    private Boolean isCrossBorder;
    /**
     * 水印标签
     */
    private String psTags;
    /**
     * 标签
     */
    private String labels;
    /**
     * 品牌
     */
    private String brandId;

    private List<String> brandIds;

    private List<String> labelIds;

    /**
     * 1 品牌聚合 2 标签聚合
     */
    private Integer aggs;

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public List<String> getCategoryCodes() {
        return categoryCodes;
    }

    public void setCategoryCodes(List<String> categoryCodes) {
        this.categoryCodes = categoryCodes;
    }

    public Boolean getIsNew() {
        return isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public DateRange getDateRange() {
        return dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public Integer getFrom() {
        return from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getKeywords() {
        return Keywords;
    }

    public void setKeywords(String keywords) {
        Keywords = keywords;
    }

    public Boolean getIsCrossBorder() {
        return isCrossBorder;
    }

    public void setIsCrossBorder(Boolean isCrossBorder) {
        this.isCrossBorder = isCrossBorder;
    }

    public String getPsTags() {
        return psTags;
    }

    public void setPsTags(String psTags) {
        this.psTags = psTags;
    }

    public String getLabels() {
        return labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public List<String> getBrandIds() {
        return brandIds;
    }

    public void setBrandIds(List<String> brandIds) {
        this.brandIds = brandIds;
    }

    public List<String> getLabelIds() {
        return labelIds;
    }

    public void setLabelIds(List<String> labelIds) {
        this.labelIds = labelIds;
    }

    public Integer getAggs() {
        return aggs;
    }

    public void setAggs(Integer aggs) {
        this.aggs = aggs;
    }
}
