/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.sms.service.impl;

import com.thebeastshop.pegasus.integration.sms.SmsProperties;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.integration.sms.service.SmsService;
import com.thebeastshop.pegasus.sms.PegasusSmsFacade;
import com.thebeastshop.pegasus.sms.cond.SmsSendLogCond;
import com.thebeastshop.pegasus.sms.model.SmsContentRequest;
import com.thebeastshop.pegasus.sms.model.SmsResult;
import com.thebeastshop.pegasus.sms.model.SmsSendLog;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanliSmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(BeanliSmsServiceImpl.class);
    private String url = SmsProperties.getConfig("beanli.url");
    private String urlSend = SmsProperties.getConfig("beanli.url.send");
    private String userId = SmsProperties.getConfig("beanli.userId");
    private String account = SmsProperties.getConfig("beanli.account");
    private String password = SmsProperties.getConfig("beanli.password");
    private PegasusSmsFacade pegasusSmsFacade = PegasusSmsFacade.getInstance();

    @Override
    public boolean send(SmsVO smsVO) {
        SmsContentRequest request = new SmsContentRequest();
        request.setType(smsVO.getType());
        request.setCountryNumber(smsVO.getCountryNumber());
        request.setContent(smsVO.getContent());
        request.setPhoneList(smsVO.getMobileList());
        request.setSendTime(smsVO.getSendTime());
        SmsResult result = this.pegasusSmsFacade.sendSms(request);
        if (result == null) {
            return false;
        }
        return result.getStatus() == SmsResult.STATUS_SUCCESS;
    }

    @Override
    public List<SmsSendLog> checkSendLog(SmsSendLogCond cond) {
        return this.pegasusSmsFacade.findSmsLogByParams(cond);
    }
}

