/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.express.yto;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.web.util.http.HttpRequest;
import com.thebeastshop.pegasus.web.util.http.HttpResponse;
import com.thebeastshop.pegasus.web.util.http.HttpUtil;
import java.net.URLEncoder;
import java.util.ResourceBundle;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YtoUtil {
    private static final Logger log = LoggerFactory.getLogger(YtoUtil.class);
    private static YtoUtil instance = new YtoUtil();
    private String apiUrl;
    private String parternId;
    private String clientId;
    private String customerId;

    private YtoUtil() {
        ResourceBundle config = ResourceBundle.getBundle("pegasus-integration/express/yto");
        this.apiUrl = config.getString("apiUrl");
        this.parternId = config.getString("parternId");
        this.clientId = config.getString("clientId");
        this.customerId = config.getString("customerId");
    }

    public static YtoUtil getInstance() {
        return instance;
    }

    public String createOrder(PackageInfo packageInfo) {
        String packageCode = "SO123456";
        try {
            StringBuilder xmlBuilder = new StringBuilder();
            xmlBuilder.append("<RequestOrder>");
            xmlBuilder.append("    <clientID>" + this.clientId + "</clientID>");
            xmlBuilder.append("    <logisticProviderID>YTO</logisticProviderID>");
            xmlBuilder.append("    <customerId>" + this.customerId + "</customerId>");
            xmlBuilder.append("    <txLogisticID>" + this.clientId + packageCode + "</txLogisticID>");
            xmlBuilder.append("    <tradeNo>" + packageCode + "</tradeNo>");
            xmlBuilder.append("    <totalServiceFee>0</totalServiceFee>");
            xmlBuilder.append("    <codSplitFee>0</codSplitFee>");
            xmlBuilder.append("    <orderType>1</orderType>");
            xmlBuilder.append("    <serviceType>1</serviceType>");
            xmlBuilder.append("    <flag>0</flag>");
            xmlBuilder.append("    <sendStartTime></sendStartTime>");
            xmlBuilder.append("    <sendEndTime></sendEndTime>");
            xmlBuilder.append("    <goodsValue>1</goodsValue>");
            xmlBuilder.append("    <itemsValue>1</itemsValue>");
            xmlBuilder.append("    <insuranceValue>0</insuranceValue>");
            xmlBuilder.append("    <special></special>");
            xmlBuilder.append("    <remark></remark>");
            xmlBuilder.append("    <deliverNo></deliverNo>");
            xmlBuilder.append("    <type>1</type>");
            xmlBuilder.append("    <totalValue>1</totalValue>");
            xmlBuilder.append("    <itemsWeight>1</itemsWeight>");
            xmlBuilder.append("    <packageOrNot>1</packageOrNot>");
            xmlBuilder.append("    <orderSource>1</orderSource>");
            xmlBuilder.append("    <sender>");
            xmlBuilder.append("        <name>\u6c6a\u660e\u65b0</name>");
            xmlBuilder.append("        <postCode>123456</postCode>");
            xmlBuilder.append("        <phone>1234567</phone>");
            xmlBuilder.append("        <mobile>18221885929</mobile>");
            xmlBuilder.append("        <prov>\u4e0a\u6d77\u5e02</prov>");
            xmlBuilder.append("        <city>\u4e0a\u6d77\u5e02,\u957f\u5b81\u533a</city>");
            xmlBuilder.append("        <address>\u4e0a\u6d77\u5e02\u9752\u6d66\u533a\u534e\u5f90\u516c\u8def\u6c11\u5174\u5927\u9053</address>");
            xmlBuilder.append("    </sender>");
            xmlBuilder.append("    <receiver>");
            xmlBuilder.append("        <name>\u6c6a\u660e\u65b0</name>");
            xmlBuilder.append("        <postCode>123456</postCode>");
            xmlBuilder.append("        <phone>1234567</phone>");
            xmlBuilder.append("        <mobile>18221885929</mobile>");
            xmlBuilder.append("        <prov>\u6d59\u6c5f\u7701</prov>");
            xmlBuilder.append("        <city>\u91d1\u534e\u5e02</city>");
            xmlBuilder.append("        <address>\u8d64\u677e\u8def308\u53f7</address>");
            xmlBuilder.append("    </receiver>");
            xmlBuilder.append("    <items>");
            xmlBuilder.append("        <item>");
            xmlBuilder.append("            <itemName>36ab0b08-3b5c-4423-a352-08477f050e55</itemName>");
            xmlBuilder.append("            <number>2</number>");
            xmlBuilder.append("            <itemValue>50</itemValue>");
            xmlBuilder.append("        </item>");
            xmlBuilder.append("        <item>");
            xmlBuilder.append("            <itemName>0a4e51b9-5616-4feb-b8a8-d2e1ba24401f</itemName>");
            xmlBuilder.append("            <number>2</number>");
            xmlBuilder.append("            <itemValue>50</itemValue>");
            xmlBuilder.append("        </item>");
            xmlBuilder.append("    </items>");
            xmlBuilder.append("</RequestOrder>");
            String data_digest = new String(Base64.encodeBase64((byte[])DigestUtils.md5((String)(xmlBuilder.toString() + this.parternId))));
            String queryString = "logistics_interface=" + URLEncoder.encode(xmlBuilder.toString(), "UTF-8") + "&data_digest=" + URLEncoder.encode(data_digest, "UTF-8") + "&clientId=" + URLEncoder.encode(this.clientId, "UTF-8");
            HttpRequest req = new HttpRequest();
            req.setUrl(this.apiUrl + "?" + queryString).setNeedBody(true);
            HttpResponse resp = new HttpUtil().request(req, null, 200, true);
            String responseString = resp.getBody();
            log.error("\u8bf7\u6c42\u7684\u8fd4\u56de\u4fe1\u606f\uff1a" + responseString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "123";
    }

    public static void main(String[] args) {
        String a = YtoUtil.getInstance().createOrder(null);
        System.out.println(a);
    }
}

