/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.express.fed;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncoder;
import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.integration.exception.IntegrationException;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.PackageSkuInfo;
import com.thebeastshop.pegasus.integration.express.fed.common.XmltoString;
import com.thebeastshop.pegasus.integration.express.fed.ws.Test;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.XMLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedUtil {
    private static final Logger log = LoggerFactory.getLogger(FedUtil.class);
    private final Semaphore semaphore = new Semaphore(2);
    private volatile boolean canUse = true;
    public static final int _BLOCKING_TIMEOUT = 20;
    public static final int _WAITING_TIMEOUT = 30;
    private volatile int _MAX_THREAD_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    public static final String PROD_PATH = File.separator + "home" + File.separator + "vmuser" + File.separator + "key" + File.separator;
    public static final String TEMP_IMG_PATH = File.separator + "home" + File.separator + "vmuser" + File.separator + "temp_img" + File.separator;
    private String NumURL = "https://cnci.apac.fedex.com:60443/ci/internal/remote/orderInfo";
    private String ImgURL = "https://cnci.apac.fedex.com:60443/ci/internal/remote/orderPrint";
    private static String COMPANY_CODE = "000060";
    private static String PAYMENT_ACCOUNT = "331893056";
    private static String SENDER_ACCOUNT = "331893056";
    private static final String SENDER_INFO_NAME = " \u91ce\u517d\u6d3e(" + PAYMENT_ACCOUNT + ")";
    private static final String SENDER_COMPANY_NAME = "\u91ce\u517d\u6d3e\u82b1\u5e97";
    private static final String SENDER_TELEPHONE = "021-32580718";
    private static final String SENDER_PROVINCE = "\u4e0a\u6d77";
    private static final String SENDER_CITY = "\u4e0a\u6d77\u5e02";
    private static final String SENDER_DISTRICT = "\u95f5\u884c\u533a";
    private static final String PAYMENT_METHOD = "\u53d1\u4ef6\u4eba\u6708\u7ed3";
    private static final String SERVICE = "\u4f18\u5148\u8fbe";
    private static final String IS_COLLECTION_ON_DELIVERY = "\u5426";
    private static final String PACKAGE_TYPE = "\u5176\u5b83\u5305\u88c5";
    private static final String PACKAGE_NUMBER = "1";
    private static final String IMAGE_STYLE = "\u4e09\u8054\u5355";
    private static final String IS_INSURANCE = "\u5426";

    private FedUtil() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("pegasus-integration/express/fed");
            this.NumURL = (String)StringUtils.defaultIfBlank((CharSequence)resourceBundle.getString("numurl"), (CharSequence)this.NumURL);
            this.ImgURL = (String)StringUtils.defaultIfBlank((CharSequence)resourceBundle.getString("imgurl"), (CharSequence)this.ImgURL);
            PAYMENT_ACCOUNT = (String)StringUtils.defaultIfBlank((CharSequence)resourceBundle.getString("paymentAccount"), (CharSequence)PAYMENT_ACCOUNT);
            COMPANY_CODE = (String)StringUtils.defaultIfBlank((CharSequence)resourceBundle.getString("companyCode"), (CharSequence)COMPANY_CODE);
            SENDER_ACCOUNT = (String)StringUtils.defaultIfBlank((CharSequence)resourceBundle.getString("senderAccount"), (CharSequence)SENDER_ACCOUNT);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
    }

    public static FedUtil getInstance() {
        FedUtil fedUtil = new FedUtil();
        return fedUtil;
    }

    public String orderFedExpressInfo(PackageInfo packageInfo, Boolean needImg) {
        block12: {
            if (!this.canUse) {
                return null;
            }
            try {
                String requestXMLStr = this.getExpressNoXML(packageInfo);
                URL theUrl = new URL(this.NumURL);
                HttpsURLConnection httpsConn = (HttpsURLConnection)theUrl.openConnection();
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, null, null);
                SSLSocketFactory sslsf = sslContext.getSocketFactory();
                httpsConn.setSSLSocketFactory(sslsf);
                httpsConn.setConnectTimeout(5000);
                httpsConn.setRequestMethod("POST");
                httpsConn.setDoOutput(true);
                httpsConn.setRequestProperty("Content-Type", "application/xml");
                OutputStream os = httpsConn.getOutputStream();
                byte[] buf = requestXMLStr.getBytes();
                os.write(buf);
                os.flush();
                os.close();
                String xmlToString = null;
                if (httpsConn.getResponseCode() != 200) break block12;
                InputStream is = httpsConn.getInputStream();
                InputStreamReader reader = new InputStreamReader(is, "utf-8");
                xmlToString = XmltoString.xmlToString(reader);
                is.close();
                reader.close();
                String orderNo = XMLUtil.parseString((String)"/ResponseMessage/MessageContent/message/orderNumber", (String)xmlToString);
                String trackingNumber = XMLUtil.parseString((String)"/ResponseMessage/MessageContent/message/trackingNumber", (String)xmlToString);
                String successFlag = XMLUtil.parseString((String)"/ResponseMessage/MessageContent/message/successFlag", (String)xmlToString);
                if (successFlag.equals("False")) {
                    String errMessage = XMLUtil.parseString((String)"/ResponseMessage/MessageContent/message/errMessage", (String)xmlToString);
                    throw new RuntimeException("\u751f\u6210\u5feb\u9012\u5355\u5931\u8d25\uff1a" + errMessage);
                }
                packageInfo.setExpressOrderNo(orderNo);
                packageInfo.setDeliveryCode(trackingNumber);
                if (!needImg.booleanValue() || !EmptyUtil.isNotEmpty((String)orderNo) || !EmptyUtil.isNotEmpty((String)trackingNumber)) break block12;
                String expressImgURL = this.getFedExpressImgURL(orderNo, trackingNumber);
                if (EmptyUtil.isNotEmpty((String)expressImgURL)) {
                    packageInfo.setExpressImgURL(expressImgURL);
                    File file = new File(TEMP_IMG_PATH + DateUtil.format((Date)Calendar.getInstance().getTime(), (String)"yyyyMMddHHmmssSSS") + ".tif");
                    FedUtil fedUtil = new FedUtil();
                    fedUtil.getFedExpressImgPath(expressImgURL, file.getAbsolutePath());
                    FileOutputStream out = null;
                    StringBuilder url = new StringBuilder();
                    try {
                        ImageDecoder decoder = ImageCodec.createImageDecoder((String)"tiff", (File)file, null);
                        for (int i = 0; i < decoder.getNumPages(); ++i) {
                            File file1 = new File(TEMP_IMG_PATH + DateUtil.format((Date)Calendar.getInstance().getTime(), (String)"yyyyMMddHHmmssSSS") + ".png");
                            out = new FileOutputStream(file1.getAbsoluteFile());
                            ImageEncoder encoder = ImageCodec.createImageEncoder((String)"png", (OutputStream)out, null);
                            encoder.encode(decoder.decodeAsRenderedImage(i));
                            String imgUrl = fedUtil.uploadPicToOss(file1);
                            if (url.length() > 0) {
                                url.append(",");
                                url.append(imgUrl);
                            } else {
                                url.append(imgUrl);
                            }
                            out.close();
                        }
                    }
                    catch (Exception e) {
                        e.getMessage();
                    }
                    packageInfo.setExpressImgPath(url.toString());
                }
                httpsConn.disconnect();
                return trackingNumber;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getMessage().indexOf("\u751f\u6210\u5feb\u9012\u5355\u5931\u8d25\uff1a\u4f20\u5165\u6570\u636e\u683c\u5f0f\u4e0d\u5339\u914d\u3002\u6536\u4ef6\u4eba\u533a\u6216\u53bf\u4fe1\u606f\u4e0d\u6b63\u786e") >= 0) {
                    int position;
                    String custAddr = packageInfo.getCustAddr();
                    if (custAddr != null && custAddr.length() > 0 && (position = custAddr.lastIndexOf("-")) > 0) {
                        custAddr = custAddr.substring(0, position + 1) + "\u5176\u5b83\u533a";
                        packageInfo.setCustAddr(custAddr);
                        return this.orderFedExpressInfo(packageInfo, (Boolean)true);
                    }
                }
                this.setCanUse(true);
                throw new RuntimeException(e.getMessage());
            }
        }
        return null;
    }

    private String uploadPicToOss(File file) {
        if (file == null) {
            return null;
        }
        try {
            String fileName = file.getName();
            String suffix = "";
            int idx = fileName.lastIndexOf(".");
            if (idx != -1) {
                suffix = fileName.substring(idx + 1);
            }
            return PegasusIntegrationFacade.getInstance().getOssUtilBean().uploadImg(suffix, new FileInputStream(file));
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5230OSS\u65f6\u51fa\u9519\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderFedExpressInfo(List<PackageInfo> packageInfos, Boolean needImg) {
        if (CollectionUtils.isEmpty(packageInfos)) {
            return;
        }
        try {
            this.semaphore.tryAcquire(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new IntegrationException("IG1001", "\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        try {
            ExecutorService executor = Executors.newFixedThreadPool(this._MAX_THREAD_SIZE);
            for (PackageInfo packageInfo : packageInfos) {
                executor.execute(new FedExpressNoTask(packageInfo, needImg));
            }
            executor.shutdown();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
        finally {
            this.semaphore.release();
            this.setCanUse(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFedExpressImgURL(List<PackageInfo> packageInfos) {
        if (CollectionUtils.isEmpty(packageInfos)) {
            return;
        }
        try {
            this.semaphore.tryAcquire(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new IntegrationException("IG1001", "\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        try {
            ExecutorService executor = Executors.newFixedThreadPool(this._MAX_THREAD_SIZE);
            for (PackageInfo packageInfo : packageInfos) {
                executor.execute(new FedExpressImgURL(packageInfo));
            }
            executor.shutdown();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
        finally {
            this.semaphore.release();
            this.setCanUse(true);
        }
    }

    protected String getExpressNoXML(PackageInfo packageInfo) throws IOException {
        if (EmptyUtil.isEmpty((Object)packageInfo)) {
            return null;
        }
        if (CollectionUtils.isEmpty(packageInfo.getSkus())) {
            return null;
        }
        Element root = new Element("RequestMessage");
        Element MAC = new Element("MAC");
        Element MessageContent = new Element("MessageContent");
        Element serialId = new Element("serialId");
        serialId.addContent(FedUtil.getUUID().toString());
        Element companyCode = new Element("companyCode");
        companyCode.addContent(COMPANY_CODE);
        Element imageStyle = new Element("imageStyle");
        imageStyle.addContent(IMAGE_STYLE);
        Element functionCode = new Element("functionCode");
        functionCode.addContent("OrderCreate");
        Element requestTime = new Element("requestTime");
        requestTime.addContent(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        Element requestContent = new Element("requestContent");
        Element shipInfo = new Element("shipInfo");
        Element senderAccount = new Element("senderAccount");
        senderAccount.addContent(SENDER_ACCOUNT);
        Element orderNumber = new Element("orderNumber");
        orderNumber.addContent(FedUtil.getUniqueOrderNum(packageInfo.getOrderNo()));
        Element senderInfo = new Element("senderInfo");
        Element name = new Element("name");
        name.addContent(SENDER_INFO_NAME);
        Element telephone = new Element("telephone");
        if (packageInfo.getChannelCode() != null && !packageInfo.getChannelCode().equals("")) {
            if (EmptyUtil.isNotEmpty((String)packageInfo.getServicePhone())) {
                telephone.addContent(packageInfo.getServicePhone());
            } else {
                telephone.addContent("400-9200-108");
            }
        } else {
            telephone.addContent(SENDER_TELEPHONE);
        }
        Element company = new Element("company");
        company.addContent(SENDER_COMPANY_NAME);
        Element province = new Element("province");
        Element city = new Element("city");
        Element district = new Element("district");
        if (packageInfo.getWarehouseDistrict() != null) {
            String[] custAddrs = packageInfo.getWarehouseDistrict().split("-");
            if (StringUtils.isBlank((CharSequence)packageInfo.getWarehouseDistrict())) {
                custAddrs = new String[]{"", "", "", ""};
            }
            province.addContent(custAddrs[1]);
            city.addContent(custAddrs[2]);
            district.addContent(custAddrs[3]);
        }
        Element street = new Element("street");
        street.addContent(packageInfo.getWarehouseAddress());
        Element postalCode = new Element("postalCode");
        postalCode.addContent(packageInfo.getWarehousePostCode());
        Element recepientInfo = new Element("recepientInfo");
        String[] custAddrs = packageInfo.getCustAddr().split("-");
        if (StringUtils.isBlank((CharSequence)packageInfo.getCustAddr())) {
            custAddrs = new String[]{"", "", "", ""};
        }
        Element recepientName = new Element("name");
        recepientName.addContent(packageInfo.getRecName());
        Element recepientProvince = new Element("province");
        recepientProvince.addContent(custAddrs[1]);
        Element recepientCity = new Element("city");
        recepientCity.addContent(custAddrs[2]);
        if (custAddrs[2].equals("\u4e1c\u839e\u5e02")) {
            custAddrs[3] = "\u5176\u5b83\u533a";
        }
        Element recepientDistrict = new Element("district");
        if (custAddrs[3] != null && !custAddrs[3].equals("\u5176\u5b83\u533a")) {
            recepientDistrict.addContent(custAddrs[3]);
        }
        Element recepientStreet = new Element("street");
        recepientStreet.addContent(packageInfo.getRecAddress());
        Element recepientPostalCode = new Element("postalCode");
        Element recepientTelephone = new Element("telephone");
        recepientTelephone.addContent(packageInfo.getRecPhone());
        recepientInfo.addContent((Content)recepientName);
        recepientInfo.addContent((Content)recepientProvince);
        recepientInfo.addContent((Content)recepientCity);
        recepientInfo.addContent((Content)recepientDistrict);
        recepientInfo.addContent((Content)recepientStreet);
        recepientInfo.addContent((Content)recepientPostalCode);
        recepientInfo.addContent((Content)recepientTelephone);
        Element cargoInfo = new Element("cargoInfo");
        Element nameCargo = new Element("name");
        StringBuilder s = new StringBuilder();
        boolean i = false;
        if (EmptyUtil.isNotEmpty(packageInfo.getSkus())) {
            PackageSkuInfo skuInfo = packageInfo.getSkus().get(0);
            s.append(skuInfo.getLevel1CategoryName());
        }
        String categoryName = s.toString();
        nameCargo.addContent(categoryName);
        Element packageNumber = new Element("packageNumber");
        packageNumber.addContent(PACKAGE_NUMBER);
        Element termInfo = new Element("termInfo");
        Element isCollectionOnDelivery = new Element("isCollectionOnDelivery");
        isCollectionOnDelivery.addContent("\u5426");
        Element service = new Element("service");
        service.addContent(SERVICE);
        Element packageType = new Element("packageType");
        packageType.addContent(PACKAGE_TYPE);
        Element paymentMethod = new Element("paymentMethod");
        paymentMethod.addContent(PAYMENT_METHOD);
        Element paymentAccount = new Element("paymentAccount");
        paymentAccount.addContent(PAYMENT_ACCOUNT);
        Element isInsurance = new Element("isInsurance");
        isInsurance.addContent("\u5426");
        Element remarks = new Element("remarks");
        if (EmptyUtil.isNotEmpty((String)packageInfo.getRemark())) {
            remarks.addContent(packageInfo.getRemark());
        } else {
            remarks.addContent("");
        }
        MessageContent.addContent((Content)serialId);
        MessageContent.addContent((Content)companyCode);
        MessageContent.addContent((Content)functionCode);
        MessageContent.addContent((Content)requestTime);
        MessageContent.addContent((Content)requestContent);
        MessageContent.addContent((Content)imageStyle);
        requestContent.addContent((Content)shipInfo);
        shipInfo.addContent((Content)senderAccount);
        shipInfo.addContent((Content)orderNumber);
        shipInfo.addContent((Content)senderInfo);
        shipInfo.addContent((Content)recepientInfo);
        shipInfo.addContent((Content)cargoInfo);
        shipInfo.addContent((Content)termInfo);
        senderInfo.addContent((Content)name);
        senderInfo.addContent((Content)company);
        senderInfo.addContent((Content)province);
        senderInfo.addContent((Content)city);
        senderInfo.addContent((Content)district);
        senderInfo.addContent((Content)street);
        senderInfo.addContent((Content)telephone);
        senderInfo.addContent((Content)postalCode);
        cargoInfo.addContent((Content)nameCargo);
        cargoInfo.addContent((Content)packageNumber);
        termInfo.addContent((Content)isCollectionOnDelivery);
        termInfo.addContent((Content)service);
        termInfo.addContent((Content)packageType);
        termInfo.addContent((Content)paymentMethod);
        termInfo.addContent((Content)paymentAccount);
        termInfo.addContent((Content)isInsurance);
        termInfo.addContent((Content)remarks);
        root.addContent((Content)MAC);
        root.addContent((Content)MessageContent);
        Document doc = new Document(root);
        XMLOutputter out = new XMLOutputter();
        out.setFormat(Format.getCompactFormat().setEncoding("UTF-8"));
        String xmlStr = out.outputString(doc);
        String strFormMessageContent = xmlStr.substring(xmlStr.indexOf("<MessageContent>"), xmlStr.lastIndexOf("</RequestMessage>"));
        Test test = new Test();
        String mac = test.encrypt(strFormMessageContent);
        MAC.addContent(mac);
        out.setFormat(Format.getCompactFormat().setEncoding("UTF-8"));
        String xmlStr1 = out.outputString(doc);
        return xmlStr1;
    }

    public String getFedExpressImgURL(String orderCode, String ExpressCode) {
        try {
            String requestXMLStr = this.getExpressImgXML(orderCode, ExpressCode);
            URL theUrl = new URL(this.ImgURL);
            HttpsURLConnection httpsConn = (HttpsURLConnection)theUrl.openConnection();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            SSLSocketFactory sslsf = sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslsf);
            httpsConn.setConnectTimeout(5000);
            httpsConn.setRequestMethod("POST");
            httpsConn.setDoOutput(true);
            httpsConn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = httpsConn.getOutputStream();
            byte[] buf = requestXMLStr.getBytes();
            os.write(buf);
            os.flush();
            os.close();
            String xmlToString = null;
            if (httpsConn.getResponseCode() == 200) {
                InputStream is = httpsConn.getInputStream();
                InputStreamReader reader = new InputStreamReader(is, "utf-8");
                xmlToString = XmltoString.xmlToString(reader);
                is.close();
                reader.close();
            }
            String downloadURL = XMLUtil.parseString((String)"/ResponseMessage/MessageContent/message/downloadURL", xmlToString);
            httpsConn.disconnect();
            return downloadURL;
        }
        catch (Exception e) {
            log.error("error:" + e.toString());
            return null;
        }
    }

    public String checkFedStatus(String orderCode, String ExpressCode) {
        try {
            String requestXMLStr = this.getExpressImgXML(orderCode, ExpressCode);
            URL theUrl = new URL(this.ImgURL);
            HttpsURLConnection httpsConn = (HttpsURLConnection)theUrl.openConnection();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            SSLSocketFactory sslsf = sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslsf);
            httpsConn.setConnectTimeout(5000);
            httpsConn.setRequestMethod("POST");
            httpsConn.setDoOutput(true);
            httpsConn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = httpsConn.getOutputStream();
            byte[] buf = requestXMLStr.getBytes();
            os.write(buf);
            os.flush();
            os.close();
            if (httpsConn.getResponseCode() == 200) {
                InputStream in = httpsConn.getInputStream();
                InputStreamReader reader = new InputStreamReader(in, "utf-8");
                String xmlToString = XmltoString.xmlToString(reader);
                String status = XMLUtil.parseString((String)"/ResponseMessage/MessageContent/message/status", (String)xmlToString);
                return status;
            }
            httpsConn.disconnect();
        }
        catch (Exception e) {
            log.error("error:" + e.toString());
        }
        return null;
    }

    public String getFedExpressImgPath(String url, String path) {
        try {
            URL theUrl = new URL(url);
            HttpsURLConnection httpsConn = (HttpsURLConnection)theUrl.openConnection();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            SSLSocketFactory sslsf = sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslsf);
            httpsConn.setConnectTimeout(5000);
            httpsConn.setRequestMethod("POST");
            httpsConn.setDoOutput(true);
            httpsConn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = httpsConn.getOutputStream();
            byte[] buf = new byte[]{};
            os.write(buf);
            os.flush();
            os.close();
            if (httpsConn.getResponseCode() == 200) {
                InputStream in = httpsConn.getInputStream();
                File f = new File(path);
                BufferedInputStream bis = new BufferedInputStream(in);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                int len = 2048;
                byte[] b = new byte[len];
                while ((len = bis.read(b)) != -1) {
                    bos.write(b, 0, len);
                }
                bos.flush();
                bis.close();
                bos.close();
            }
            httpsConn.disconnect();
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getExpressImgXML(String orderCode, String expressCode) {
        try {
            Element root = new Element("RequestMessage");
            Element MAC = new Element("MAC");
            Element MessageContent = new Element("MessageContent");
            Element serialId = new Element("serialId");
            UUID uuid = FedUtil.getUUID();
            serialId.addContent(uuid.toString());
            Element companyCode = new Element("companyCode");
            companyCode.addContent(COMPANY_CODE);
            Element functionCode = new Element("functionCode");
            functionCode.addContent("OrderPrint");
            Element requestTime = new Element("requestTime");
            requestTime.addContent(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            Element requestContent = new Element("requestContent");
            Element orderInfo = new Element("orderInfo");
            Element trackingNumber = new Element("trackingNumber");
            trackingNumber.addContent(expressCode);
            Element orderNumber = new Element("orderNumber");
            orderNumber.addContent(orderCode);
            MessageContent.addContent((Content)serialId);
            MessageContent.addContent((Content)companyCode);
            MessageContent.addContent((Content)functionCode);
            MessageContent.addContent((Content)requestTime);
            MessageContent.addContent((Content)requestContent);
            requestContent.addContent((Content)orderInfo);
            orderInfo.addContent((Content)orderNumber);
            orderInfo.addContent((Content)trackingNumber);
            root.addContent((Content)MAC);
            root.addContent((Content)MessageContent);
            Document doc = new Document(root);
            XMLOutputter out = new XMLOutputter();
            out.setFormat(Format.getCompactFormat().setEncoding("UTF-8"));
            String xmlStr = out.outputString(doc);
            String strFormMessageContent = xmlStr.substring(xmlStr.indexOf("<MessageContent>"), xmlStr.lastIndexOf("</RequestMessage>"));
            Test test = new Test();
            String mac = test.encrypt(strFormMessageContent);
            MAC.addContent(mac);
            out.setFormat(Format.getCompactFormat().setEncoding("UTF-8"));
            String xml = out.outputString(doc);
            return xml;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static UUID getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid;
    }

    protected static String getUniqueOrderNum(String orderNum) {
        StringBuilder orderNo = new StringBuilder(64);
        orderNo.append(orderNum);
        orderNo.append(DateUtil.format((Date)DateUtil.getNow(), (String)"yyyyMMddHHmmss"));
        return orderNo.toString();
    }

    public void setCanUse(boolean canUse) {
        this.canUse = canUse;
    }

    public static void main(String[] args) throws IOException {
        File file = new File(TEMP_IMG_PATH + DateUtil.format((Date)Calendar.getInstance().getTime(), (String)"yyyyMMddHHmmss") + ".tif");
        File file1 = new File(TEMP_IMG_PATH + DateUtil.format((Date)Calendar.getInstance().getTime(), (String)"yyyyMMddHHmmss") + ".png");
        FedUtil fedUtil = new FedUtil();
        fedUtil.getFedExpressImgPath("https://cnci.apac.fedex.com:60443/ci/internal/remote/download?code=2c90c0b454aa97720154e770c7d97edb", file.getAbsolutePath());
        FileOutputStream out = new FileOutputStream(file1.getAbsoluteFile());
        ImageDecoder decoder = ImageCodec.createImageDecoder((String)"tiff", (File)file, null);
        ImageEncoder encoder = ImageCodec.createImageEncoder((String)"png", (OutputStream)out, null);
        encoder.encode(decoder.decodeAsRenderedImage());
        out.close();
        String imgUrl = fedUtil.uploadPicToOss(file1);
        System.out.println(imgUrl);
    }

    class FedExpressImgURL
    implements Runnable {
        private PackageInfo packageInfo;

        public FedExpressImgURL(PackageInfo packageInfo) {
            this.packageInfo = packageInfo;
        }

        @Override
        public void run() {
            String url = FedUtil.this.getFedExpressImgURL(this.packageInfo.getExpressOrderNo(), this.packageInfo.getDeliveryCode());
            this.packageInfo.setExpressImgURL(url);
        }
    }

    class FedExpressNoTask
    implements Runnable {
        private PackageInfo packageInfo;
        private Boolean needImg;

        public FedExpressNoTask(PackageInfo packageInfo, Boolean needImg) {
            this.packageInfo = packageInfo;
            this.needImg = needImg;
        }

        @Override
        public void run() {
            FedUtil.this.orderFedExpressInfo(this.packageInfo, this.needImg);
        }
    }
}

