/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.express.exfresh;

import com.thebeastshop.pegasus.integration.exception.IntegrationException;

public class IdWorker {
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private static long twepoch = 1488729600L;
    private static long workerIdBits = 2L;
    private static long datacenterIdBits = 2L;
    private static long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)workerIdBits;
    private static long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)datacenterIdBits;
    private static long sequenceBits = 8L;
    private long workerIdShift = sequenceBits;
    private long datacenterIdShift = sequenceBits + workerIdBits;
    private long timestampLeftShift = sequenceBits + workerIdBits + datacenterIdBits;
    private long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)sequenceBits;
    private long lastTimestamp = -1L;
    private static Object syncRoot = new Object();

    public IdWorker(long workerId, long datacenterId) {
        if (workerId > maxWorkerId || workerId < 0L) {
            throw new IntegrationException("IG1001", String.format("worker Id can't be greater than %d or less than 0", maxWorkerId));
        }
        if (datacenterId > maxDatacenterId || datacenterId < 0L) {
            throw new IntegrationException("IG1001", String.format("datacenter Id can't be greater than %d or less than 0", maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId() {
        Object object = syncRoot;
        synchronized (object) {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                throw new IntegrationException("IG1001", String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & this.sequenceMask;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - twepoch << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
        }
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis() / 1000L;
    }
}

