/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.express;

import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.RouteInfo;
import com.thebeastshop.pegasus.integration.express.fed.FedUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ExpressUtil {
    public static void genSFDeliveryCode(PackageInfo packageInfo) {
        PegasusIntegrationFacade.getInstance().getSFUtilBean().generateExpressNo(packageInfo);
    }

    public static void genSFDeliveryCode(List<PackageInfo> packageInfos) {
        PegasusIntegrationFacade.getInstance().getSFUtilBean().generateExpressNo(packageInfos);
    }

    public static boolean validateBySFDeliveryCode(String deliveryCode) {
        if (CollectionUtils.isEmpty(PegasusIntegrationFacade.getInstance().getSFUtilBean().findRouteInfo(deliveryCode, false))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static List<RouteInfo> findSFRouteInfo(String deliveryCode) {
        return PegasusIntegrationFacade.getInstance().getSFUtilBean().findRouteInfo(deliveryCode, true);
    }

    public static void orderFedExpressInfo(PackageInfo packageInfo, Boolean needImg) {
        FedUtil.getInstance().orderFedExpressInfo(packageInfo, needImg);
    }

    public static void orderFedExpressInfo(List<PackageInfo> packageInfos, Boolean needImg) {
        FedUtil.getInstance().orderFedExpressInfo(packageInfos, needImg);
    }

    public static String getFedExpressImgURL(String orderCode, String expressCode) {
        return FedUtil.getInstance().getFedExpressImgURL(orderCode, expressCode);
    }

    public static void getFedExpressImgURL(List<PackageInfo> packageInfos) {
        FedUtil.getInstance().getFedExpressImgURL(packageInfos);
    }

    public static String getFedExpressImgPath(String url, String path) {
        return FedUtil.getInstance().getFedExpressImgPath(url, path);
    }

    public static String getFedExpressImgPath(String orderCode, String deliveryCode, String path) {
        String url = ExpressUtil.getFedExpressImgURL(orderCode, deliveryCode);
        if (EmptyUtil.isEmpty((String)url)) {
            return null;
        }
        return ExpressUtil.getFedExpressImgPath(url, path);
    }

    public static String checkFedStatus(String orderCode, String expressCode) {
        return FedUtil.getInstance().checkFedStatus(orderCode, expressCode);
    }
}

