/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.email;

import com.thebeastshop.pegasus.integration.email.MailAuthenticator;
import com.thebeastshop.pegasus.integration.email.MailSenderInfo;
import com.thebeastshop.pegasus.integration.email.vo.EmailAttachmentVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSender {
    private final Logger log = LoggerFactory.getLogger(MailSender.class);

    public boolean send(MailSenderInfo mailInfo) {
        MailAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MailAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            Address[] tos = new Address[mailInfo.getToAddress().length];
            for (int i = 0; i < mailInfo.getToAddress().length; ++i) {
                tos[i] = new InternetAddress(mailInfo.getToAddress()[i]);
            }
            mailMessage.setRecipients(Message.RecipientType.TO, tos);
            if (mailInfo.getCopyTo() != null && mailInfo.getCopyTo().length > 0) {
                Address[] copys = new Address[mailInfo.getCopyTo().length];
                for (int i = 0; i < mailInfo.getCopyTo().length; ++i) {
                    copys[i] = new InternetAddress(mailInfo.getCopyTo()[i]);
                }
                mailMessage.addRecipients(Message.RecipientType.CC, copys);
            }
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            String mailContent = mailInfo.getContent();
            MimeMultipart mm = new MimeMultipart();
            mailMessage.setContent((Multipart)mm);
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setContent((Object)mailContent, "text/html;charset=UTF-8");
            mm.addBodyPart((BodyPart)contentPart);
            List<EmailAttachmentVO> attachmentList = mailInfo.getAttachmentList();
            if (EmptyUtil.isNotEmpty(attachmentList)) {
                for (EmailAttachmentVO attachment : attachmentList) {
                    MimeBodyPart mdp = new MimeBodyPart();
                    DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(attachment.getBytes(), "application/octet-stream"));
                    mdp.setDataHandler(dh);
                    mdp.setFileName(MimeUtility.encodeText((String)attachment.getFileName()));
                    mm.addBodyPart((BodyPart)mdp);
                }
            }
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException e) {
            this.log.warn("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.log.warn("", (Throwable)e);
        }
        return false;
    }
}

