/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.email;

import com.thebeastshop.pegasus.integration.email.EmailProperties;
import com.thebeastshop.pegasus.integration.email.MailSender;
import com.thebeastshop.pegasus.integration.email.MailSenderInfo;
import com.thebeastshop.pegasus.integration.email.vo.EmailSenderVO;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    private static final EmailUtil instance = new EmailUtil();
    private String mailServerHost = EmailProperties.getConfig("mailServerHost");
    private String mailServerPort = EmailProperties.getConfig("mailServerPort");
    private List<String> senders = Arrays.asList(EmailProperties.getConfig("senders").split(","));
    private MailSender mailSender = new MailSender();

    private EmailUtil() {
    }

    public static EmailUtil getInstance() {
        return instance;
    }

    public boolean send(EmailVO emailVO, EmailSenderVO emailSenderVO) {
        if (emailSenderVO == null) {
            return false;
        }
        if (EmptyUtil.isEmpty(emailVO.getToAddressList())) {
            return false;
        }
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setMailServerHost(this.mailServerHost);
        mailInfo.setMailServerPort(this.mailServerPort);
        mailInfo.setValidate(true);
        mailInfo.setUserName(emailSenderVO.getUserName());
        mailInfo.setPassword(emailSenderVO.getPassword());
        mailInfo.setFromAddress(emailSenderVO.getUserName());
        mailInfo.setToAddress(emailVO.getToAddressList().toArray(new String[0]));
        if (emailVO.getToCopyList() != null && emailVO.getToCopyList().size() > 0) {
            mailInfo.setCopyTo(emailVO.getToCopyList().toArray(new String[0]));
        }
        mailInfo.setSubject(emailVO.getSubject());
        mailInfo.setContent(emailVO.getContent());
        mailInfo.setAttachmentList(emailVO.getAttachmentList());
        return this.mailSender.send(mailInfo);
    }

    public boolean send(EmailVO emailVO) {
        return this.send(emailVO, this.findSender("webmaster"));
    }

    private EmailSenderVO findSender(String sender) {
        if (!this.senders.contains(sender)) {
            return null;
        }
        EmailSenderVO emailSenderVO = new EmailSenderVO();
        emailSenderVO.setUserName(EmailProperties.getConfig("sender." + sender + ".userName"));
        emailSenderVO.setPassword(EmailProperties.getConfig("sender." + sender + ".password"));
        return emailSenderVO;
    }
}

