/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.sms.service.impl;

import com.thebeastshop.pegasus.integration.sms.SmsProperties;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.integration.sms.service.SmsService;
import com.thebeastshop.pegasus.sms.PegasusSmsFacade;
import com.thebeastshop.pegasus.sms.cond.SmsSendLogCond;
import com.thebeastshop.pegasus.sms.model.SmsContentRequest;
import com.thebeastshop.pegasus.sms.model.SmsResult;
import com.thebeastshop.pegasus.sms.model.SmsSendLog;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * @author Royan
 * @version $Id: BeanliSmsServiceImpl.java, v 0.1 2015-08-13 下午5:06
 */
public class BeanliSmsServiceImpl implements SmsService {

    private final static Logger log      = LoggerFactory.getLogger(BeanliSmsServiceImpl.class);

    private String              url      = SmsProperties.getConfig("beanli.url");
    private String              urlSend  = SmsProperties.getConfig("beanli.url.send");
    private String              userId   = SmsProperties.getConfig("beanli.userId");
    private String              account  = SmsProperties.getConfig("beanli.account");
    private String              password = SmsProperties.getConfig("beanli.password");

    private PegasusSmsFacade pegasusSmsFacade = PegasusSmsFacade.getInstance();


    /**
     * 发送
     * @param smsVO
     * @return 是否全部成功
     */
    @Override
    public boolean send(SmsVO smsVO) {
        SmsContentRequest request = new SmsContentRequest();
        request.setType(smsVO.getType());
        request.setCountryNumber(smsVO.getCountryNumber());
        request.setContent(smsVO.getContent());
        request.setPhoneList(smsVO.getMobileList());
        request.setSendTime(smsVO.getSendTime());
        SmsResult result = pegasusSmsFacade.sendSms(request);
        if (result == null) {
            return false;
        }
        if (result.getStatus() != SmsResult.STATUS_SUCCESS) {
            return false;
        }
        return true;
    }

    @Override
    public List<SmsSendLog> checkSendLog(SmsSendLogCond cond) {
            return  pegasusSmsFacade.findSmsLogByParams(cond);
    }


//    @Override
/*
    public boolean send(SmsVO smsVO) {
        String content = smsVO.getContent();
        String sendTime = smsVO.getSendTime() != null ? DateUtil.format(smsVO.getSendTime(),
            DateUtil.DEFAULT_DATETIME_FORMAT) : "";
        List<String> mobileList = smsVO.getMobileList();

        if (EmptyUtil.isEmpty(content) || EmptyUtil.isEmpty(mobileList)) {
            return false;
        }

        boolean allSuccess = true;
        for (String mobile : mobileList) {
            HttpRequest req = new HttpRequest();
            req.setUrl(url + urlSend).setNeedBody(true).setNeedCookie(false)
                .setNeedHeaderMap(false);
            req.setParams("action=send&userid=" + userId + "&account=" + account + "&password="
                          + password + "&mobile=" + mobile + "&content=" + content + "&sendTime="
                          + sendTime + "&extno=");

            HttpUtil httpUtil = new HttpUtil();
            try {
                HttpResponse resp = httpUtil.request(req, null, HttpStatus.SC_OK, true);
                log.debug(resp.getBody());
            } catch (Exception e) {
                log.warn("", e);
                allSuccess = false;
            }
        }
        return allSuccess;
    }
*/

}