/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.sms;

import com.thebeastshop.pegasus.integration.exception.IntegrationException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Royan
 * @version $Id: SmsTemplateUtil.java, v 0.1 2015-09-01 下午2:52
 */
public class SmsTemplateUtil {

    private static final Logger          log                 = LoggerFactory
                                                                 .getLogger(SmsTemplateUtil.class);

    private static Map<String, Template> __cachedTemplateMap = new ConcurrentHashMap<>();

    static {
        ResourceBundle config = ResourceBundle.getBundle("pegasus-integration/config/smsTemplate");
        Configuration cfg = new Configuration();
        Enumeration<String> codeTempNames = config.getKeys();
        while (codeTempNames.hasMoreElements()) {
            String codeTemplateName = codeTempNames.nextElement();
            try {
                Template tpl = new Template(codeTemplateName, new String(config.getString(
                    codeTemplateName).getBytes("UTF-8"), "UTF-8"), cfg);
                //Template tpl = new Template(codeTemplateName, config.getString(codeTemplateName), cfg);
                __cachedTemplateMap.put(codeTemplateName, tpl);
            } catch (Exception e) {
                log.warn("", e);
            }
        }
    }

    /**
     * 生成内容
     *
     * @param templateName CODE模板名
     * @param params           参数
     * @return CODE
     */
    public static String fromTemplate(String templateName, Map<String, Object> params) {
        String result;
        Template tpl = __cachedTemplateMap.get(templateName);
        if (tpl == null) {
            throw new IntegrationException("can't find template for name : " + templateName);
        } else {
            StringWriter sw = new StringWriter();
            try {
                tpl.process(params, sw);
                result = sw.toString();
            } catch (Exception e) {
                log.warn("", e);
                throw new IntegrationException("SmsTemplateUtil.fromTemplate failed : "
                                               + templateName + " : " + params);
            }
        }
        return result;
    }

    //    public static void main(String[] args) {
    //        System.out.println(SmsTemplateUtil.fromTemplate("DELIVERY_PROXY_RECEIVED", null));
    //    }
}