package com.thebeastshop.pegasus.integration.pay.vo;

import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;

/**
 * 支付宝接口返回值
 * create by com.thebeastshop.pegasus.integration.pay.vo trunk :author lijing
 * User:lijing
 * DATE : 2017/4/28
 * TIME : 14:04
 * trunk.
 */
@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement(name = "alipay")
public class AliPayVO implements Serializable {
    @XmlElement(name = "is_success")
    private String isSuccess;
    @XmlElement(name = "error")
    private String error;
    @XmlElement(name = "sign")
    private String sign;

    @XmlElement(name = "sign_type")
    private String signType;
    @XmlElement(name = "response")
    private List<AliPayResponseVO> responseVO;

    public String getIsSuccess() {
        return isSuccess;
    }

    public void setIsSuccess(String isSuccess) {
        this.isSuccess = isSuccess;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public List<AliPayResponseVO> getResponseVO() {
        return responseVO;
    }

    public void setResponseVO(List<AliPayResponseVO> responseVO) {
        this.responseVO = responseVO;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("isSuccess", isSuccess)
                .append("error", error)
                .append("sign", sign)
                .append("signType", signType)
                .append("responseVO", responseVO)
                .toString();
    }
}
