package com.thebeastshop.pegasus.integration.pay;

import com.thebeastshop.pegasus.integration.constants.PayThirdConstants;
import com.thebeastshop.pegasus.integration.pay.vo.AliPayVO;
import com.thebeastshop.pegasus.integration.pay.vo.PayStatusVO;
import com.thebeastshop.pegasus.integration.pay.vo.WeiXinVO;
import com.thebeastshop.pegasus.util.comm.DateTool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 支付状态查询工具 现在支持 支付宝  海外支付宝  微信
 * create by com.thebeastshop.pegasus.integration.pay trunk :author lijing
 * User:lijing
 * DATE : 2017/4/28
 * TIME : 10:43
 * trunk.
 */
public class PayStatusQueryUtil {
    /**logger*/
    private final Logger log = LoggerFactory.getLogger(PayStatusQueryUtil.class);
    /**返回对象*/
    private static final PayStatusQueryUtil instance = new PayStatusQueryUtil();

    public static PayStatusQueryUtil getInstance() {
        return instance;
    }

    public static void main(String[] args) {
       /* String a[]={"SO0120180001906582","SO0120180001906589",A
                "SO0120180001906890",
                "SO0120180001906898",
                "SO0120180001906917",
                "SO0120180001907031",
                "SO0120180001907067",
                "SO0120180001907090",
                "SO0120180001907138",
                "SO0120180001907168",
                "SO0120180001907285"};*/
/*String a[]={"SO0120180001902354",
        "SO0120180001902366",
        "SO0120180001902406",
        "SO0120180001903106",
        "SO0120180001903369",
        "SO0120180001903464",
        "SO0120180001903579",
        "SO0120180001904058",
        "SO0120180001904106",
        "SO0120180001904116",
        "SO0120180001904384",
        "SO0120180001904782",
        "SO0120180001904844",
        "SO0120180001905211",
        "SO0120180001905231",
        "SO0120180001905296",
        "SO0120180001905317",
        "SO0120180001905721",
        "SO0120180001906248",
        "SO0120180001906253",
        "SO0120180001906267",
        "SO0120180001906618",
        "SO0120180001906619",
        "SO0120180001906623",
        "SO0120180001906875",
        "SO0120180001906890",
        "SO0120180001907031",
        "SO0120180001907067",
        "SO0120180001907090",
        "SO0120180001907138",
        "SO0120180001907168",
        "SO0120180001907285",
        "SO0120180001905343",
        "SO0120180001905373",
        "SO0120180001906616"

};
        for(int i = 0 ; i < a.length;i++){
            PayStatusQueryUtil payStatusQueryUtil = PayStatusQueryUtil.getInstance();
            //   Boolean re =  payStatusQueryUtil.findThirdPayStatus("SO0120180000243571", false, PayThirdConstants.PAYMENT_TYPE.ALI_PAY);
            //  System.out.println(re);
            Boolean re1 =  payStatusQueryUtil.findThirdPayStatus(a[i],false,PayThirdConstants.PAYMENT_TYPE.ALI_PAY);

        }*/

        PayStatusQueryUtil payStatusQueryUtil = PayStatusQueryUtil.getInstance();
        PayStatusVO payStatusVO = payStatusQueryUtil.findThirdPayStatusVO("SO0110060001953968",3,false);
      //  Boolean re1 =  payStatusQueryUtil.findThirdPayStatus("SO0120490001882563",false,PayThirdConstants.PAYMENT_TYPE.OVER_SEA_ALI_PAY);
        System.out.println(payStatusVO.toString());
    }

    /**
     * 支付返回状态 vo
     * @param orderCode
     * @param isApp
     * @param isOverSea
     * @return
     */
    public PayStatusVO findThirdPayStatusVO(String orderCode,int channelType,Boolean isOverSea ){
        PayStatusVO payStatusVO = new PayStatusVO();
        Boolean res = false;
        if(StringUtils.isNotBlank(orderCode)){
            if(isOverSea){
                /**海外支付宝*/
                AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, PayThirdConstants.PAYMENT_TYPE.OVER_SEA_ALI_PAY);
                convertPayStatusVO( PayThirdConstants.PAYMENT_TYPE.OVER_SEA_ALI_PAY,aliPayVO,null,payStatusVO);

            }else{
                 /*如果不是海淘   如果是app的走 app的微信和支付宝    如果不是app 走官网的微信和支付宝*/
                /**微信*/
                WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode,channelType);
                convertPayStatusVO( PayThirdConstants.PAYMENT_TYPE.WEI_XIN,null,weiXinVO,payStatusVO);
                

                // 线下支付宝是布鲁爱
                if(channelType==PayThirdConstants.CHANNEL_TYPE.IPOS){
                	 /**支付宝*/
                    if(!payStatusVO.getIsSuccess()) {
                        AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, PayThirdConstants.PAYMENT_TYPE.BLA_ALI_PAY);
                        convertPayStatusVO( PayThirdConstants.PAYMENT_TYPE.BLA_ALI_PAY,aliPayVO,null,payStatusVO);
                    }
                }else{
                	 /**支付宝*/
                    if(!payStatusVO.getIsSuccess()) {
                        AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, PayThirdConstants.PAYMENT_TYPE.ALI_PAY);
                        convertPayStatusVO( PayThirdConstants.PAYMENT_TYPE.ALI_PAY,aliPayVO,null,payStatusVO);
                    }
                }

               

            }
        }
        return payStatusVO;
    }

    
    
    /**
     * 设置vo
     * @param type  支付类型
     * @param aliPayVO
     * @param weiXinVO
     * @param payStatusVO
     */
    private void convertPayStatusVO(int type,AliPayVO aliPayVO,WeiXinVO weiXinVO,PayStatusVO payStatusVO){
        if(type == PayThirdConstants.PAYMENT_TYPE.WEI_XIN){
            Boolean f =  ifWeiXinPayStatus(weiXinVO);
            payStatusVO.setIsSuccess(f);
            payStatusVO.setPayType(type);
            if(f){
                payStatusVO.setPayPrice(weiXinVO.getTotalFee() + "");
                payStatusVO.setTradeOrderCode(weiXinVO.getTransactionId());
                if(StringUtils.isNotBlank(weiXinVO.getTimeEnd())){
                    payStatusVO.setPayTime(DateTool.string2Date(weiXinVO.getTimeEnd(), "yyyyMMddHHmmss"));
                }
            }
        }else{
            Boolean f =  ifPayStatus(aliPayVO);
            payStatusVO.setIsSuccess(f);
            payStatusVO.setPayType(type);
            if(f){
                Double to = Double.valueOf(aliPayVO.getResponseVO().get(0).getTrade().getTotalFee()) * 100;
                payStatusVO.setPayPrice(to.intValue() + "");
                payStatusVO.setTradeOrderCode(aliPayVO.getResponseVO().get(0).getTrade().getTradeNo());
                if(StringUtils.isNotBlank(aliPayVO.getResponseVO().get(0).getTrade().getGmtPayment())){
                    payStatusVO.setPayTime(DateTool.string2Date(aliPayVO.getResponseVO().get(0).getTrade().getGmtPayment(),DateTool.FORMAT_DATETIME));
                }
            }
        }
    }

    /**
     * 通过订单号查询 此订单是否支付成功
     * @param orderCode  订单code
     * @param isApp  是否是app
     * @param payType 支付类型 使用 常量  PayThirdConstants.PAYMENT_TYPE 里面的常量
     * @return boolean  true 支付成功  false 没有支付或者异常
     */
    public Boolean findThirdPayStatus(String orderCode,int payFlg,int payType){
        Boolean res = false;
        if(StringUtils.isNotBlank(orderCode)){
            /**微信*/
            if(payType == PayThirdConstants.PAYMENT_TYPE.WEI_XIN){
                WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode,payFlg);
                res = ifWeiXinPayStatus(weiXinVO);
            }
            /**支付宝*/
            if(payType == PayThirdConstants.PAYMENT_TYPE.ALI_PAY){
                AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, payType);
                res =ifPayStatus(aliPayVO);
            }
            /**海外支付宝*/
            if(payType == PayThirdConstants.PAYMENT_TYPE.OVER_SEA_ALI_PAY){
                AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, payType);
                res =ifPayStatus(aliPayVO);
            }
        }
        return res;
    }

    /**
     * 查询第三方支付信息
     * @param orderCode 订单code
     * @param isApp  是否是app
     * @param isOverSea 是否是海涛
     * @return
     */
    public Boolean findThirdPayStatus(String orderCode,int payFlg,Boolean isOverSea){
        Boolean res = false;
         if(StringUtils.isNotBlank(orderCode)){
             if(isOverSea){
                 /**海外支付宝*/
                 AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, PayThirdConstants.PAYMENT_TYPE.OVER_SEA_ALI_PAY);
                 res =ifPayStatus(aliPayVO);
             }else{
                 /*如果不是海淘   如果是app的走 app的微信和支付宝    如果不是app 走官网的微信和支付宝*/
                 if(payFlg==1){
                     /**微信*/
                     WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode,payFlg);
                     res = ifWeiXinPayStatus(weiXinVO);
                     /**支付宝*/
                     if(!res) {
                         AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, PayThirdConstants.PAYMENT_TYPE.ALI_PAY);
                         res = ifPayStatus(aliPayVO);
                     }
                 }else if(payFlg==3){
                     /**微信*/
                     WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode,payFlg);
                     res = ifWeiXinPayStatus(weiXinVO);
                     /**支付宝*/
                     if(!res) {
                         AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, PayThirdConstants.PAYMENT_TYPE.ALI_PAY);
                         res = ifPayStatus(aliPayVO);
                     }
                 }else{
                	 /**微信*/
                     WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode,payFlg);
                     res = ifWeiXinPayStatus(weiXinVO);
                     /**支付宝*/
                     if(!res) {
                         AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, PayThirdConstants.PAYMENT_TYPE.ALI_PAY);
                         res = ifPayStatus(aliPayVO);
                     }
                 }
             }
         }
        return res;
    }
    /**
     * 微信判断
     * @param weiXinVO
     * @return
     */
    private Boolean ifWeiXinPayStatus(WeiXinVO weiXinVO){
        Boolean re = false;
        if(null != weiXinVO && "SUCCESS".equals(weiXinVO.getResultCode())){
            if("SUCCESS".equals(weiXinVO.getTradeState())){
                re = true;
            }else{
                log.info("查询微信tradeStat ={}", weiXinVO.getTradeState());
            }
        }else{
            System.out.println("查询微信返回异常e={}"+weiXinVO);
            log.info("查询微信返回异常e={}", weiXinVO);
        }
        return re;
    }
    /**
     * 判断支付状态
     * @param aliPayVO
     * @return
     */
    private Boolean ifPayStatus( AliPayVO aliPayVO){
        Boolean re = false;
        if(null != aliPayVO && "T".equals(aliPayVO.getIsSuccess())){
            if(CollectionUtils.isNotEmpty(aliPayVO.getResponseVO()) && aliPayVO.getResponseVO().get(0).getTrade() != null){
                System.out.println(aliPayVO.getResponseVO().get(0).getTrade().getRefundStatus()+"|"+aliPayVO.getResponseVO().get(0).getTrade().getTradeStatus());
                if(aliPayVO.getResponseVO().get(0).getTrade().getRefundStatus() == null && ("TRADE_FINISHED".equals(aliPayVO.getResponseVO().get(0).getTrade().getTradeStatus()) || "TRADE_SUCCESS".equals(aliPayVO.getResponseVO().get(0).getTrade().getTradeStatus()))){
                    System.out.println(aliPayVO.getResponseVO().get(0).getTrade().getOutTradeNo()+"|"+aliPayVO.getResponseVO().get(0).getTrade().getTradeNo() + "|" + aliPayVO.getResponseVO().get(0).getTrade().getGmtPayment() +"|"+aliPayVO.getResponseVO().get(0).getTrade().getTotalFee());
                    re = true;
                }
            }
        }else{
            System.out.println("查询支付宝返回异常e={}"+aliPayVO);
            log.info("查询支付宝返回异常e={}", aliPayVO);
        }
        return re;
    }
}