package com.thebeastshop.pegasus.integration.pay;

import com.thebeastshop.pegasus.integration.constants.PayThirdConstants;
import com.thebeastshop.pegasus.integration.pay.util.AlipayHttpUtil;
import com.thebeastshop.pegasus.integration.pay.util.XMLBeanUtil;
import com.thebeastshop.pegasus.integration.pay.vo.AliPayVO;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.*;

/**
 * 支付宝的
 * create by com.thebeastshop.pegasus.integration.pay trunk :author lijing
 * User:lijing
 * DATE : 2017/4/28
 * TIME : 14:00
 * trunk.
 */
public class AliPayUtil {
       /**日志*/
       private final static Logger logger = LoggerFactory.getLogger(AliPayUtil.class);

    public static AliPayVO findPayMementByOrder(String orderCode,int channelType){
        return handleParam(orderCode,channelType);
    }

    /**========================================tool======**/

    private static  AliPayVO handleParam(String orderCode,int channelType){
        AliPayVO aliPayVO = null;
        try {
            //拼装参数
            Map<String, String> params = convertAliPay(orderCode, channelType);
            //得到url 参数 发送http 请求
            String urlParam = getUrlParam(params);
            //http 请求发送
            String res = AlipayHttpUtil.sendGetUrl(PayThirdConstants.Ali_PAY_URL.url+urlParam);
            if(StringUtils.isNotBlank(res)){
                aliPayVO = XMLBeanUtil.toObject(res,AliPayVO.class);
            }
        }catch (Exception e){
            logger.error("支付宝调用错误 =e{}",e);
        }
        return aliPayVO;
    }

/*    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
        AliPayVO aliPayVO =   handleParam("SO0120180000243561",PayThirdConstants.PAYMENT_TYPE.ALI_PAY);
        System.out.println(System.currentTimeMillis());
        System.out.println(aliPayVO);
    }*/

    /**
     * 将map 转为支付穿
     * @param param
     */
    private static String getUrlParam(Map<String,String> param){
        String urlParam = "";
        int i = 0;
        for (Map.Entry<String, String> entry : param.entrySet()) {
           if(i == 0){
               urlParam += entry.getKey()+"="+entry.getValue();
           }else{
               urlParam += "&"+entry.getKey()+"="+entry.getValue();
           }
            i++;
        }
        return urlParam;
    }

    /***
     * 包装map
     * @param orderCode
     * @param payType
     * @return
     */
    private static  Map<String,String> convertAliPay(String orderCode,int channelType){
        Map<String,String> params = new HashMap<String, String>();
        //普通支付宝
        if(channelType == PayThirdConstants.PAYMENT_TYPE.ALI_PAY){
            params.put("_input_charset",PayThirdConstants.Ali_PAY_CONFIG._input_charset );
            params.put("out_trade_no", orderCode);
            params.put("partner", PayThirdConstants.Ali_PAY_CONFIG.partner);
            params.put("service",  PayThirdConstants.Ali_PAY_CONFIG.service);
            params.put("sign", getSign(params,PayThirdConstants.Ali_PAY_CONFIG.key,PayThirdConstants.Ali_PAY_CONFIG._input_charset));
            params.put("sign_type",PayThirdConstants.Ali_PAY_CONFIG.sign_type);
          //海外支付宝
        } else if(channelType == PayThirdConstants.PAYMENT_TYPE.OVER_SEA_ALI_PAY){
            params.put("_input_charset",PayThirdConstants.OVER_SEA_ALI_PAY_CONFIG._input_charset );
            params.put("out_trade_no", orderCode);
            params.put("partner", PayThirdConstants.OVER_SEA_ALI_PAY_CONFIG.partner);
            params.put("service",  PayThirdConstants.OVER_SEA_ALI_PAY_CONFIG.service);
            params.put("sign", getSign(params,PayThirdConstants.OVER_SEA_ALI_PAY_CONFIG.key,PayThirdConstants.OVER_SEA_ALI_PAY_CONFIG._input_charset));
            params.put("sign_type",PayThirdConstants.OVER_SEA_ALI_PAY_CONFIG.sign_type);
        }else if(channelType == PayThirdConstants.PAYMENT_TYPE.BLA_ALI_PAY){
            params.put("_input_charset",PayThirdConstants.Ali_PAY_CONFIG_BLA._input_charset );
            params.put("out_trade_no", orderCode);
            params.put("partner", PayThirdConstants.Ali_PAY_CONFIG_BLA.partner);
            params.put("service", PayThirdConstants.Ali_PAY_CONFIG_BLA.service);
            params.put("sign", getSign(params,PayThirdConstants.Ali_PAY_CONFIG_BLA.key,PayThirdConstants.Ali_PAY_CONFIG_BLA._input_charset));
            params.put("sign_type",PayThirdConstants.Ali_PAY_CONFIG_BLA.sign_type);
        }
        return params;
    }

    /**签名*/
    private static  String getSign(Map<String, String> sortedParmas,String key,String inputChar) {
        String sign = "";
        String plainText = createLinkString(sortedParmas);// 获取拼接的未加密文本
        sign = sign(plainText, key,
               inputChar);

        return sign;
    }

    /**
     * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
     * @param params 需要排序并参与字符拼接的参数组
     * @return 拼接后字符串
     */
    private static  String createLinkString(Map<String, String> params) {

        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);

        String prestr = "";

        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = params.get(key);

            if (i == keys.size() - 1) {//拼接时，不包括最后一个&字符
                prestr = prestr + key + "=" + value;
            } else {
                prestr = prestr + key + "=" + value + "&";
            }
        }

        return prestr;
    }

    /**
     * 签名
     * @param text
     * @param key
     * @param input_charset
     * @return
     */
    private  static String sign(String text, String key, String input_charset) {
        text = text + key;
        return DigestUtils.md5Hex(getContentBytes(text, input_charset));
    }

    /**
     * @param content
     * @param charset
     * @return
     * @throws
     * @throws UnsupportedEncodingException
     */
    private  static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5签名过程中出现错误,指定的编码集不对,您目前指定的编码集是:" + charset);
        }
    }




}
