package com.thebeastshop.pegasus.integration.express.fed;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncoder;
import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.integration.exception.IntegrationException;
import com.thebeastshop.pegasus.integration.exception.IntegrationExceptionErrorCode;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.PackageSkuInfo;
import com.thebeastshop.pegasus.integration.express.fed.common.XmltoString;
import com.thebeastshop.pegasus.integration.express.fed.ws.SSL;
import com.thebeastshop.pegasus.integration.express.fed.ws.Test;
import com.thebeastshop.pegasus.integration.oss.OssUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.XMLUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import java.io.*;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/**
 * Created by devin.li on 2016/2/19.
 */
public class FedUtil {

    private static final Logger log = LoggerFactory.getLogger(FedUtil.class);

    private final Semaphore semaphore = new Semaphore(2);
    private volatile boolean canUse = true;

    public static final int _BLOCKING_TIMEOUT = 20;
    public static final int _WAITING_TIMEOUT = 30;
    private volatile int _MAX_THREAD_SIZE = Runtime.getRuntime().availableProcessors() * 2;

    //    private static final ClassPathResource PROD_PATH = new ClassPathResource("pegasus-integration"+File.separator+"keys"+File.separator+"");
    public static final String PROD_PATH = File.separator+"home"+File.separator+"vmuser"+File.separator+"key"+File.separator;
    public static final String TEMP_IMG_PATH = File.separator+"home"+File.separator+"vmuser"+File.separator+"temp_img"+File.separator;
//    // UAT environment
//    private String NumURL = "https://cnciuat.apac.fedex.com:60443/ci/internal/remote/orderInfo";
//    private String ImgURL = "https://cnciuat.apac.fedex.com:60443/ci/internal/remote/orderPrint";

    //PROD environment
    private String NumURL = "https://cnci.apac.fedex.com:60443/ci/internal/remote/orderInfo";
    private String ImgURL = "https://cnci.apac.fedex.com:60443/ci/internal/remote/orderPrint";
    //公司名称代码
    private static String COMPANY_CODE = "000060";
    //付款账号
    private static String PAYMENT_ACCOUNT = "331893056";
    //寄件账号
    private static String SENDER_ACCOUNT = "331893056";


    //发件人姓名
    private static final String SENDER_INFO_NAME = " 野兽派("+PAYMENT_ACCOUNT+")";
    //发件公司名称
    private static final String SENDER_COMPANY_NAME = "野兽派花店";
    //发件人电话
    private static final String SENDER_TELEPHONE = "021-32580718";
    //发件人省
    private static final String SENDER_PROVINCE = "上海";
    //发件人市
    private static final String SENDER_CITY = "上海市";
    //发件人区域
    private static final String SENDER_DISTRICT = "闵行区";
    //发件人街道
//    private static final String SENDER_STREET = "元电路388号4号楼";
    //发件人邮编
//    private static final String SENDER_POSTAL_CODE = "200052";
    //付款方式
    private static final String PAYMENT_METHOD = "发件人月结";
    //服务类型
    private static final String SERVICE = "优先达";
    //是否代收货款
    private static final String IS_COLLECTION_ON_DELIVERY = "否";
    //包装类型
    private static final String PACKAGE_TYPE = "其它包装";
    //包裹数量
    private static final String PACKAGE_NUMBER = "1";
    //生成图像类型
    private static final String IMAGE_STYLE = "三联单";
    //是否保险
    private static final String IS_INSURANCE = "否";

    /**
     * 生产环境参数
     */
    private FedUtil(){
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("pegasus-integration/express/fed");
            NumURL = StringUtils.defaultIfBlank(resourceBundle.getString("numurl"),NumURL);
            ImgURL = StringUtils.defaultIfBlank(resourceBundle.getString("imgurl"),ImgURL);
            PAYMENT_ACCOUNT = StringUtils.defaultIfBlank(resourceBundle.getString("paymentAccount"), PAYMENT_ACCOUNT);
            COMPANY_CODE = StringUtils.defaultIfBlank(resourceBundle.getString("companyCode"), COMPANY_CODE);
            SENDER_ACCOUNT = StringUtils.defaultIfBlank(resourceBundle.getString("senderAccount"), SENDER_ACCOUNT);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("", e);
        }
    }
    public static FedUtil getInstance() {
        FedUtil fedUtil = new FedUtil();
        return fedUtil;
    }
    /**
     * 单个
     * 请求并获取FedExpress快递信息
     * @param packageInfo
     * @return
     */
    public String orderFedExpressInfo(PackageInfo packageInfo,Boolean needImg) {
        if (!canUse) {
            return null;
        }
        try {
            String requestXMLStr = getExpressNoXML(packageInfo);
            URL theUrl=new URL(NumURL);

            HttpsURLConnection httpsConn=(HttpsURLConnection)theUrl.openConnection();
            SSLContext sslContext=SSLContext.getInstance("TLSv1.2");
            sslContext.init(null,null,null);
            SSLSocketFactory sslsf=sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslsf);
            httpsConn.setConnectTimeout(5000);
            httpsConn.setRequestMethod("POST");
            httpsConn.setDoOutput(true);
            httpsConn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = httpsConn.getOutputStream();
            byte[] buf = requestXMLStr.getBytes();
            os.write(buf);
            os.flush();
            os.close();
            String xmlToString=null;
            if (httpsConn.getResponseCode() == 200) {
                InputStream is = httpsConn.getInputStream();
                InputStreamReader reader = new InputStreamReader(is, "utf-8");
                xmlToString= XmltoString.xmlToString(reader);
                is.close();
                reader.close();
                String orderNo = XMLUtil.parseString("/ResponseMessage/MessageContent/message/orderNumber", xmlToString);
                String trackingNumber = XMLUtil.parseString("/ResponseMessage/MessageContent/message/trackingNumber", xmlToString);
                String successFlag = XMLUtil.parseString("/ResponseMessage/MessageContent/message/successFlag", xmlToString);
                if(successFlag.equals("False")){
                    String errMessage = XMLUtil.parseString("/ResponseMessage/MessageContent/message/errMessage", xmlToString);
                    throw new RuntimeException("生成快递单失败："+errMessage);
                }
                packageInfo.setExpressOrderNo(orderNo);
                packageInfo.setDeliveryCode(trackingNumber);
                if (needImg){
                    if (EmptyUtil.isNotEmpty(orderNo) && EmptyUtil.isNotEmpty(trackingNumber)){
                        String expressImgURL = getFedExpressImgURL(orderNo, trackingNumber);
                        if (EmptyUtil.isNotEmpty(expressImgURL)) {
                            packageInfo.setExpressImgURL(expressImgURL);
                            File file = new File(TEMP_IMG_PATH + DateUtil.format(Calendar.getInstance().getTime(),DateUtil.DATE_STR_FORMAT)+".tif");
                            FedUtil fedUtil = new FedUtil();
                            fedUtil.getFedExpressImgPath(expressImgURL,file.getAbsolutePath());

                            FileOutputStream out = null;
                            StringBuilder url = new StringBuilder();
                            try {
                                ImageDecoder decoder = ImageCodec.createImageDecoder("tiff",file,null);
                                for(int i = 0;i < decoder.getNumPages();i++){
                                    File file1 = new File(TEMP_IMG_PATH + DateUtil.format(Calendar.getInstance().getTime(),DateUtil.DATE_STR_FORMAT)+".png");
                                    out = new FileOutputStream(file1.getAbsoluteFile());
                                    ImageEncoder encoder = ImageCodec.createImageEncoder("png",out,null);
                                    encoder.encode( decoder.decodeAsRenderedImage(i) );
                                    String imgUrl = fedUtil.uploadPicToOss(file1);
                                    if(url.length() > 0){
                                        url.append(",");
                                        url.append(imgUrl);
                                    }else{
                                        url.append(imgUrl);
                                    }
                                    out.close();
                                }


                            } catch (Exception e) {
                                e.getMessage();
                            }
                            packageInfo.setExpressImgPath(url.toString());

                        }
                        httpsConn.disconnect();
                        return trackingNumber;
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            if(e.getMessage().indexOf("生成快递单失败：传入数据格式不匹配。收件人区或县信息不正确") >= 0){
                String custAddr = packageInfo.getCustAddr();
                if(custAddr != null && custAddr.length() > 0){
                    int position = custAddr.lastIndexOf("-");
                    if(position > 0){
                        custAddr = custAddr.substring(0,position + 1) + "其它区";
                        packageInfo.setCustAddr(custAddr);
                        return  orderFedExpressInfo(packageInfo,true);
                    }
                }
            }else{
//                e.printStackTrace();
                setCanUse(true);
                throw new RuntimeException(e.getMessage());
            }
        }
        return null;
    }
    private String uploadPicToOss(File file) {
        if (file == null)
            return null;
        try {
            String fileName = file.getName();
            String suffix = "";
            int idx = fileName.lastIndexOf(".");
            if (idx != -1) {
                suffix = fileName.substring(idx + 1);
            }
            return PegasusIntegrationFacade.getInstance().getOssUtilBean().uploadImg(suffix, new FileInputStream(file));
        } catch (IOException e) {
            log.warn("", e);
            throw new RuntimeException("文件上传到OSS时出错！");
        }
    }
    /**
     * 批量
     * 请求并获取FedExpress快递号
     * @param packageInfos
     * @return
     */
    public void orderFedExpressInfo(List<PackageInfo> packageInfos,Boolean needImg) {
        if (CollectionUtils.isEmpty(packageInfos)) return;
        try {
            /**
             * semaphore: multi
             */
            semaphore.tryAcquire(_BLOCKING_TIMEOUT, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            log.warn("", e);
            throw new IntegrationException(IntegrationExceptionErrorCode.EXPRESS_EXCEPTION, "系统忙，请稍后再试！");
        }

        try {
            ExecutorService executor = Executors.newFixedThreadPool(_MAX_THREAD_SIZE);
            for (PackageInfo packageInfo : packageInfos) {
                executor.execute(new FedExpressNoTask(packageInfo,needImg));
            }
            executor.shutdown();
            executor.awaitTermination(_WAITING_TIMEOUT, TimeUnit.SECONDS);
        } catch (Exception e) {
            log.warn("", e);
        } finally {
            semaphore.release();
            setCanUse(true);
        }
    }

    /**
     * 批量
     * 获取Fed快递单下载url
     * @param packageInfos
     * @return
     */
    public void getFedExpressImgURL(List<PackageInfo> packageInfos) {
        if (CollectionUtils.isEmpty(packageInfos)) return;
        try {
            /**
             * semaphore: multi
             */
            semaphore.tryAcquire(_BLOCKING_TIMEOUT, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            log.warn("", e);
            throw new IntegrationException(IntegrationExceptionErrorCode.EXPRESS_EXCEPTION, "系统忙，请稍后再试！");
        }

        try {
            ExecutorService executor = Executors.newFixedThreadPool(_MAX_THREAD_SIZE);
            for (PackageInfo packageInfo : packageInfos) {
                executor.execute(new FedExpressImgURL(packageInfo));
            }
            executor.shutdown();
            executor.awaitTermination(_WAITING_TIMEOUT, TimeUnit.SECONDS);
        } catch (Exception e) {
            log.warn("", e);
        } finally {
            semaphore.release();
            setCanUse(true);
        }
    }


    /**
     * 拼接FedExpress请求快递单号报文
     * @param packageInfo
     * @return
     */
    protected String getExpressNoXML(PackageInfo packageInfo) throws IOException {
        if (EmptyUtil.isEmpty(packageInfo)) return null;
        if (CollectionUtils.isEmpty(packageInfo.getSkus())) return null;
        Element root = new Element("RequestMessage");

        Element MAC = new Element("MAC");

        Element MessageContent = new Element("MessageContent");

        Element serialId = new Element("serialId");
        serialId.addContent(getUUID().toString());

        Element companyCode = new Element("companyCode");
        companyCode.addContent(COMPANY_CODE);

        Element imageStyle = new Element("imageStyle");
        imageStyle.addContent(IMAGE_STYLE);

        Element functionCode = new Element("functionCode");
        functionCode.addContent("OrderCreate");

        Element requestTime = new Element("requestTime");
        requestTime.addContent(DateUtil.format(new Date(), "yyyyMMddHHmmss"));

        Element requestContent = new Element("requestContent");

        Element shipInfo = new Element("shipInfo");

        Element senderAccount = new Element("senderAccount");
        senderAccount.addContent(SENDER_ACCOUNT);

        Element orderNumber = new Element("orderNumber");
        orderNumber.addContent(getUniqueOrderNum(packageInfo.getOrderNo()));

        Element senderInfo = new Element("senderInfo");

        Element name = new Element("name");
        name.addContent(SENDER_INFO_NAME);
        Element telephone = new Element("telephone");
        if(packageInfo.getChannelCode() != null && !packageInfo.getChannelCode().equals("")){
//            if(packageInfo.getChannelCode().equals("CHN1031") || packageInfo.getChannelCode().equals("CHN2046") ||  packageInfo.getChannelCode().equals("CHN2042")){
//                telephone.addContent("021-60900320");
//            }else{
//                telephone.addContent("400-9200-108");
//            }
            if(EmptyUtil.isNotEmpty(packageInfo.getServicePhone())){
                telephone.addContent(packageInfo.getServicePhone());
            }else{
                telephone.addContent("400-9200-108");
            }
        }else{
            telephone.addContent(SENDER_TELEPHONE);

        }
        Element company = new Element("company");
        company.addContent(SENDER_COMPANY_NAME);
        Element province = new Element("province");
        Element city = new Element("city");
        Element district = new Element("district");
        if(packageInfo.getWarehouseDistrict() != null){
            String[] custAddrs = packageInfo.getWarehouseDistrict().split("-");
            if (StringUtils.isBlank(packageInfo.getWarehouseDistrict())) {
                custAddrs = new String[]{"", "", "", ""};
            }
            province.addContent(custAddrs[1]);
            city.addContent(custAddrs[2]);
            district.addContent(custAddrs[3]);
        }
        Element street = new Element("street");
        street.addContent(packageInfo.getWarehouseAddress());
        Element postalCode = new Element("postalCode");
        postalCode.addContent(packageInfo.getWarehousePostCode());
        Element recepientInfo = new Element("recepientInfo");

        //拆分省市区
        String[] custAddrs = packageInfo.getCustAddr().split("-");
        if (StringUtils.isBlank(packageInfo.getCustAddr())) {
            custAddrs = new String[]{"", "", "", ""};
        }

        Element recepientName = new Element("name");
        recepientName.addContent(packageInfo.getRecName());

        Element recepientProvince = new Element("province");
        recepientProvince.addContent(custAddrs[1]);

        Element recepientCity = new Element("city");
        recepientCity.addContent(custAddrs[2]);
        if(custAddrs[2].equals("东莞市")){
            custAddrs[3] = "其它区";
        }
        Element recepientDistrict = new Element("district");
        if(custAddrs[3] != null && !custAddrs[3].equals("其它区")){
            recepientDistrict.addContent(custAddrs[3]);
        }

        Element recepientStreet = new Element("street");
        recepientStreet.addContent(packageInfo.getRecAddress());

        Element recepientPostalCode = new Element("postalCode");
//        recepientPostalCode.addContent();

        Element recepientTelephone = new Element("telephone");
        recepientTelephone.addContent(packageInfo.getRecPhone());

        recepientInfo.addContent(recepientName);
        recepientInfo.addContent(recepientProvince);
        recepientInfo.addContent(recepientCity);
        recepientInfo.addContent(recepientDistrict);
        recepientInfo.addContent(recepientStreet);
        recepientInfo.addContent(recepientPostalCode);
        recepientInfo.addContent(recepientTelephone);


        Element cargoInfo = new Element("cargoInfo");

        Element nameCargo = new Element("name");
        StringBuilder s = new StringBuilder();
        int i = 0;
        if(EmptyUtil.isNotEmpty(packageInfo.getSkus())){
            PackageSkuInfo skuInfo = packageInfo.getSkus().get(0);
            s.append(skuInfo.getLevel1CategoryName());
        }
//        for(PackageSkuInfo skuInfo : packageInfo.getSkus()){
//        	s.append(skuInfo.getCategoryName()).append("*").append(skuInfo.getSkuNum());
//        	s.append("\r\n  ");
//        	i++;
//        	if(i>=5){
//        		break;
//        	}
//        }
        //String categoryName = packageInfo.getSkus().get(0).getCategoryName();
        String categoryName = s.toString();
        nameCargo.addContent(categoryName);

        Element packageNumber = new Element("packageNumber");
        packageNumber.addContent(PACKAGE_NUMBER);

        Element termInfo = new Element("termInfo");

        Element isCollectionOnDelivery = new Element("isCollectionOnDelivery");
        isCollectionOnDelivery.addContent(IS_COLLECTION_ON_DELIVERY);

        Element service = new Element("service");
        service.addContent(SERVICE);

        Element packageType = new Element("packageType");
        packageType.addContent(PACKAGE_TYPE);

        Element paymentMethod = new Element("paymentMethod");
        paymentMethod.addContent(PAYMENT_METHOD);

        Element paymentAccount = new Element("paymentAccount");
        paymentAccount.addContent(PAYMENT_ACCOUNT);

        Element isInsurance = new Element("isInsurance");
        isInsurance.addContent(IS_INSURANCE);

        Element remarks = new Element("remarks");
        if(EmptyUtil.isNotEmpty(packageInfo.getRemark())){
            remarks.addContent(packageInfo.getRemark());
        }else {
            remarks.addContent("");
        }


        MessageContent.addContent(serialId);
        MessageContent.addContent(companyCode);
        MessageContent.addContent(functionCode);
        MessageContent.addContent(requestTime);
        MessageContent.addContent(requestContent);
        MessageContent.addContent(imageStyle);
        requestContent.addContent(shipInfo);

        shipInfo.addContent(senderAccount);
        shipInfo.addContent(orderNumber);
        shipInfo.addContent(senderInfo);
        shipInfo.addContent(recepientInfo);
        shipInfo.addContent(cargoInfo);
        shipInfo.addContent(termInfo);

        senderInfo.addContent(name);
        senderInfo.addContent(company);
        senderInfo.addContent(province);
        senderInfo.addContent(city);
        senderInfo.addContent(district);
        senderInfo.addContent(street);
        senderInfo.addContent(telephone);
        senderInfo.addContent(postalCode);

        cargoInfo.addContent(nameCargo);
        cargoInfo.addContent(packageNumber);


        termInfo.addContent(isCollectionOnDelivery);
        termInfo.addContent(service);
        termInfo.addContent(packageType);
        termInfo.addContent(paymentMethod);
        termInfo.addContent(paymentAccount);
        termInfo.addContent(isInsurance);
        termInfo.addContent(remarks);

        root.addContent(MAC);
        root.addContent(MessageContent);

        Document doc = new Document(root);
        XMLOutputter out = new XMLOutputter();
        out.setFormat(Format.getCompactFormat().setEncoding("UTF-8"));//设置输出的编码
        String xmlStr = out.outputString(doc);
        String strFormMessageContent = xmlStr.substring(
                xmlStr.indexOf("<MessageContent>"), xmlStr.lastIndexOf("</RequestMessage>"));//加密MAC
        Test test = new Test();
        String mac = test.encrypt(strFormMessageContent);
        MAC.addContent(mac);
        out.setFormat(Format.getCompactFormat().setEncoding("UTF-8")); //设置输出的编码
        String xmlStr1 = out.outputString(doc);
        return xmlStr1;
    }

    /**
     * 单个
     * 获取FedExpress面单URL
     * @param orderCode
     * @param ExpressCode
     * @return
     */
    public String getFedExpressImgURL(String orderCode, String ExpressCode) {
        try {
            String requestXMLStr = getExpressImgXML(orderCode, ExpressCode);
            URL theUrl=new URL(ImgURL);
            HttpsURLConnection httpsConn=(HttpsURLConnection)theUrl.openConnection();
            SSLContext sslContext=SSLContext.getInstance("TLSv1.2");
            sslContext.init(null,null,null);
            SSLSocketFactory sslsf=sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslsf);
            httpsConn.setConnectTimeout(5000);
            httpsConn.setRequestMethod("POST");
            httpsConn.setDoOutput(true);
            httpsConn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = httpsConn.getOutputStream();
            byte[] buf = requestXMLStr.getBytes();
            os.write(buf);
            os.flush();
            os.close();
            String xmlToString=null;
            if (httpsConn.getResponseCode() == 200) {
                InputStream is = httpsConn.getInputStream();
                InputStreamReader reader = new InputStreamReader(is, "utf-8");
                xmlToString= XmltoString.xmlToString(reader);
                is.close();
                reader.close();
            }
            String downloadURL = XMLUtil.parseString("/ResponseMessage/MessageContent/message/downloadURL", xmlToString);
            httpsConn.disconnect();
            return downloadURL;
        } catch (Exception e) {
            log.error("error:" + e.toString());
        }
        return null;
    }

    /**
     * 单个
     * 检查FedExpress面单状态
     * @param orderCode
     * @param ExpressCode
     * @return
     */
    public String checkFedStatus(String orderCode, String ExpressCode) {
        try {
            String requestXMLStr = getExpressImgXML(orderCode, ExpressCode);

            URL theUrl=new URL(ImgURL);
            HttpsURLConnection httpsConn=(HttpsURLConnection)theUrl.openConnection();
            SSLContext sslContext=SSLContext.getInstance("TLSv1.2");
            sslContext.init(null,null,null);
            SSLSocketFactory sslsf=sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslsf);
            httpsConn.setConnectTimeout(5000);
            httpsConn.setRequestMethod("POST");
            httpsConn.setDoOutput(true);
            httpsConn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = httpsConn.getOutputStream();
            byte[] buf = requestXMLStr.getBytes();
            os.write(buf);
            os.flush();
            os.close();
            if (httpsConn.getResponseCode() == 200) {
                InputStream in = httpsConn.getInputStream();
                InputStreamReader reader = new InputStreamReader(in, "utf-8");
                String xmlToString = XmltoString.xmlToString(reader);
                String status = XMLUtil.parseString("/ResponseMessage/MessageContent/message/status", xmlToString);
                return status;
            }
            httpsConn.disconnect();
        } catch (Exception e) {
            log.error("error:" + e.toString());
        }
        return null;
    }

    public String getFedExpressImgPath(String url,String path){
        try {
            URL theUrl=new URL(url);
            HttpsURLConnection httpsConn=(HttpsURLConnection)theUrl.openConnection();
            SSLContext sslContext=SSLContext.getInstance("TLSv1.2");
            sslContext.init(null,null,null);
            SSLSocketFactory sslsf=sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslsf);
            httpsConn.setConnectTimeout(5000);
            httpsConn.setRequestMethod("POST");
            httpsConn.setDoOutput(true);
            httpsConn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = httpsConn.getOutputStream();
            byte[] buf = new byte[0];
            os.write(buf);
            os.flush();
            os.close();
            if (httpsConn.getResponseCode() == 200) {
                InputStream in = httpsConn.getInputStream();
                File f = new File(path);
                BufferedInputStream bis = new BufferedInputStream(in);
                BufferedOutputStream  bos = new BufferedOutputStream(new FileOutputStream(f));
                int len = 2048;
                byte[] b = new byte[len];
                while ((len = bis.read(b)) != -1)
                {
                    bos.write(b, 0, len);
                }
                bos.flush();
                bis.close();
                bos.close();
            }
            httpsConn.disconnect();
            return path;
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        return null;
    }


    protected String getExpressImgXML(String orderCode,String expressCode){
        try
        {
            Element root = new Element("RequestMessage");

            Element MAC = new Element("MAC");

            Element MessageContent = new Element("MessageContent");

            Element serialId = new Element("serialId");
            UUID uuid = getUUID();
            serialId.addContent(uuid.toString());

            Element companyCode = new Element("companyCode");
            companyCode.addContent(COMPANY_CODE);

            Element functionCode = new Element("functionCode");
            functionCode.addContent("OrderPrint");

            Element requestTime = new Element("requestTime");
            requestTime.addContent(DateUtil.format(new Date(),"yyyyMMddHHmmss"));

            Element requestContent = new Element("requestContent");

            Element orderInfo = new Element("orderInfo");

            Element trackingNumber = new Element("trackingNumber");
            trackingNumber.addContent(expressCode);

            Element orderNumber = new Element("orderNumber");
            orderNumber.addContent(orderCode);

            MessageContent.addContent(serialId);
            MessageContent.addContent(companyCode);
            MessageContent.addContent(functionCode);
            MessageContent.addContent(requestTime);
            MessageContent.addContent(requestContent);

            requestContent.addContent(orderInfo);
            orderInfo.addContent(orderNumber);
            orderInfo.addContent(trackingNumber);

            root.addContent(MAC);
            root.addContent(MessageContent);

            Document doc = new Document(root);
            XMLOutputter out = new XMLOutputter();
            //设置输出的编码
            out.setFormat(Format.getCompactFormat().setEncoding("UTF-8"));
            //输出字符串
            String xmlStr = out.outputString(doc);
            //加密MAC
            String strFormMessageContent = xmlStr.substring(xmlStr.indexOf("<MessageContent>"), xmlStr.lastIndexOf("</RequestMessage>"));
            Test test = new Test();
            String mac = test.encrypt(strFormMessageContent);
            MAC.addContent(mac);
            //设置输出的编码
            out.setFormat(Format.getCompactFormat().setEncoding("UTF-8"));
            //输出字符串
            String xml = out.outputString(doc);
            return xml;
        }
        catch (Exception ex)
        {
            ex.printStackTrace();
        }
        return null;
    }


    protected static UUID getUUID(){
        UUID uuid = UUID.randomUUID();
        return uuid;
    }

    protected static String getUniqueOrderNum(String orderNum) {
        StringBuilder orderNo = new StringBuilder(64);
        orderNo.append(orderNum);
        orderNo.append(DateUtil.format(DateUtil.getNow(), "yyyyMMddHHmmss"));
        return orderNo.toString();
    }

    class FedExpressNoTask implements Runnable {
        private PackageInfo packageInfo;
        private Boolean needImg;

        public FedExpressNoTask(PackageInfo packageInfo,Boolean needImg) {
            this.packageInfo = packageInfo;
            this.needImg = needImg;
        }

        @Override
        public void run() {
            orderFedExpressInfo(packageInfo, needImg);
        }
    }



    class FedExpressImgURL implements Runnable {
        private PackageInfo packageInfo;

        public FedExpressImgURL(PackageInfo packageInfo) {
            this.packageInfo = packageInfo;
        }

        @Override
        public void run() {
            String url = getFedExpressImgURL(packageInfo.getExpressOrderNo(),packageInfo.getDeliveryCode());
            packageInfo.setExpressImgURL(url);
        }
    }

    public void setCanUse(boolean canUse) {
        this.canUse = canUse;
    }

    //    public static String getTPPath() {
//        try {
//            return FedUtil.PROD_PATH.getURL().getPath();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        return null;
//    }
    public static void main(String []args) throws IOException {
        File file = new File(TEMP_IMG_PATH + DateUtil.format(Calendar.getInstance().getTime(),DateUtil.DEFAULT_STR_FORMAT)+".tif");
        File file1 = new File(TEMP_IMG_PATH + DateUtil.format(Calendar.getInstance().getTime(),DateUtil.DEFAULT_STR_FORMAT)+".png");
        FedUtil fedUtil = new FedUtil();
        fedUtil.getFedExpressImgPath("https://cnci.apac.fedex.com:60443/ci/internal/remote/download?code=2c90c0b454aa97720154e770c7d97edb",file.getAbsolutePath());

        FileOutputStream out = new FileOutputStream(file1.getAbsoluteFile());
        ImageDecoder decoder = ImageCodec.createImageDecoder("tiff",file,null);
        ImageEncoder encoder = ImageCodec.createImageEncoder("png",out,null);
        encoder.encode( decoder.decodeAsRenderedImage() );
        out.close();
        String imgUrl = fedUtil.uploadPicToOss(file1);
        System.out.println(imgUrl);
    }

}
