package com.thebeastshop.pegasus.integration.express.exfresh;

import com.thebeastshop.pegasus.integration.exception.IntegrationException;
import com.thebeastshop.pegasus.integration.exception.IntegrationExceptionErrorCode;

/**
 * 参照http://blog.csdn.net/antony9118/article/details/52766848
 * 修改长度适应12 位
 * 每秒 2^sequenceBits 序列
 */
public class IdWorker {


    private long workerId;
    private long datacenterId;
    private long sequence = 0L;

    private static long twepoch = 1488729600000L/1000;//2017-03-06 00:00:00 秒级

    private static long workerIdBits = 2L;
    private static long datacenterIdBits = 2L;
    private static long maxWorkerId = -1L ^ (-1L << (int)workerIdBits);
    private static long maxDatacenterId = -1L ^ (-1L << (int)datacenterIdBits);
    private static long sequenceBits = 8L;

    private long workerIdShift = sequenceBits;
    private long datacenterIdShift = sequenceBits + workerIdBits;
    private long timestampLeftShift = sequenceBits + workerIdBits + datacenterIdBits;
    private long sequenceMask = -1L ^ (-1L << (int)sequenceBits);

    private long lastTimestamp = -1L;
    private static Object syncRoot = new Object();

    public IdWorker(long workerId, long datacenterId){
        // sanity check for workerId
        if (workerId > maxWorkerId || workerId < 0){
            throw new IntegrationException(IntegrationExceptionErrorCode.EXPRESS_EXCEPTION,String.format("worker Id can't be greater than %d or less than 0", maxWorkerId));
        }
        if (datacenterId > maxDatacenterId || datacenterId < 0) {
            throw new IntegrationException(IntegrationExceptionErrorCode.EXPRESS_EXCEPTION,String.format("datacenter Id can't be greater than %d or less than 0", maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public long nextId(){
        synchronized (syncRoot){
            long timestamp = timeGen();
            if (timestamp < lastTimestamp) {
                throw new IntegrationException(IntegrationExceptionErrorCode.EXPRESS_EXCEPTION,
                        String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
            }
            if (lastTimestamp == timestamp){
                sequence = (sequence + 1) & sequenceMask;
                if (sequence == 0) {
                    timestamp = tilNextMillis(lastTimestamp);
                }
            }
            else {
                sequence = 0L;
            }
            lastTimestamp = timestamp;
            return ((timestamp - twepoch) << (int)timestampLeftShift) | (datacenterId << (int)datacenterIdShift) | (workerId << (int)workerIdShift) | sequence;
        }
    }

    protected long tilNextMillis(long lastTimestamp){
        long timestamp = timeGen();
        while (timestamp <= lastTimestamp){
            timestamp = timeGen();
        }
        return timestamp;
    }

    //修改取秒
    protected long timeGen(){
        return System.currentTimeMillis()/1000;
    }
}
