package com.thebeastshop.pegasus.integration.express.exfresh;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.PackageSkuInfo;
import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.web.util.http.HttpRequest;
import com.thebeastshop.pegasus.web.util.http.HttpResponse;
import com.thebeastshop.pegasus.web.util.http.HttpUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.tools.ant.taskdefs.condition.Http;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.*;

/**
 * Created by Administrator on 2017/3/13.
 */
public class ExFreshUtil {

    private final static Logger log = LoggerFactory.getLogger(ExFreshUtil.class);

    private static ExFreshUtil instance = new ExFreshUtil();

    private static String AppId;

    private static String AppSecret;

    private static String reqUrl;

    final private static IdWorker deliveryCodeGen = new IdWorker(0,0);


    private ExFreshUtil(){
        ResourceBundle config = ResourceBundle.getBundle("pegasus-integration/express/exfresh");
        AppId = config.getString("AppId");
        AppSecret = config.getString("AppSecret");
        reqUrl = config.getString("reqUrl");
    }

    public static ExFreshUtil getInstance(){
        return instance;
    }

    public boolean submitOrder(PackageInfo packageInfo){
        ExFreshOrder order = buildOrderFromPackageInfo(packageInfo);
        boolean result = false;
        try {
            result = sendReqExFresh(order);
        }catch (Exception e){
            result = false;
        }
        return result;
    }

    private ExFreshOrder buildOrderFromPackageInfo(PackageInfo packageInfo){
        ExFreshOrder exOrder = new ExFreshOrder();
        exOrder.setCustomerName(packageInfo.getRecName());
        exOrder.setChannelType("303");
        exOrder.setCustomerId("2063EA1D-A666-4172-AE89-1D5DB8FFAC18");
        exOrder.setUserInfo(buildUserInfo());
        List<ExFreshOrderPackage> packageList = new ArrayList<>();
        packageList.add(buildExFreshOrderPackageInfo(packageInfo));
        exOrder.setOrderPackageList(packageList);
        return exOrder;
    }

    private ExFreshOrderPackage buildExFreshOrderPackageInfo(PackageInfo packageInfo){
        ExFreshOrderPackage info = new ExFreshOrderPackage();
        info.setCustomerName(packageInfo.getCustName());
        packageInfo.setDeliveryCode(deliveryCodeGen.nextId()+"");
        info.setOutOrderCode(packageInfo.getDeliveryCode());
        info.setDeliveryDateStart(packageInfo.getPlanedDeliveryDate());
        info.setDeliveryDateEnd(packageInfo.getPlanedDeliveryDate());

        info.setPaymentMethod(null);

        info.setSender("野兽派");
        info.setSenderTel(findSenderTel(packageInfo.getChannelCode()));
        info.setSenderAddress(packageInfo.getWarehouseAddress());

        info.setProductTotalAmount(packageInfo.getPaySum().toString());
        info.setTotalPrice(packageInfo.getPaySum().toString());
        info.setPaymentAmount(packageInfo.getPaySum().toString());

        info.setReceiver(packageInfo.getRecName());
        info.setReceiverTel(packageInfo.getRecPhone());
        info.setReceiverMobile(null);

        info.setReceiverProvince(packageInfo.getCustProvince());//
        info.setReceiverCity(packageInfo.getCustCity());//
        info.setReceiverAddress(packageInfo.getRecAddress());
        info.setReceiverDistrict(packageInfo.getCustDistrict());

        info.setRemark(packageInfo.getRemark());
        info.setOutPackageNumber(packageInfo.getDeliveryCode());
        info.setDeliveryStationCode(null);//
        info.setDriverName(null);//
        info.setOtsCustomerId(null);//

        info.setSenderProvince(packageInfo.getWarehouseProvince());//
        info.setSenderCity(packageInfo.getWarehouseCity());//
        info.setSenderAddress(packageInfo.getWarehouseAddress());
        info.setSenderDistrict(packageInfo.getWarehouseDistrict());//

        info.setAreaId(null);
        info.setDistrictId(null);
        info.setAreaCode(null);
        info.setPaymentId(null);

        info.setOrderSource(6);
        info.setDeliveryMobile(null);
        info.setLat(null);
        info.setLng(null);
        info.setDeliveryType(1);
        info.setDistributorId("00000000-0000-0000-0000-000000000000");
        info.setDistrictId(null);
        info.setSourceType(1);
        info.setTotalCount(packageInfo.getOrderNum());
        info.setOrderTitle("运单管理项目单元测试");//
        info.setShopId("00000000-0000-0000-0000-000000000000");

        List<OrderItem> orderItems = new ArrayList<>();
        for(PackageSkuInfo skuInfo : packageInfo.getSkus()){
            OrderItem item = new OrderItem();
            item.setPackageNum(skuInfo.getSkuNum()+"");
            item.setPackageTitle(getPackageTitle(skuInfo));
            item.setPackageWeight("0");
            item.setTotalAmount(1000);
            item.setShopId("00000000-0000-0000-0000-000000000000");
            orderItems.add(item);
        }
        info.setOrderItems(orderItems);
        return info;
    }

    private String findSenderTel(String channelCode){
        if(Constants.CHN1031CODE.equals(channelCode)
                || Constants.CHN2042CODE.equals(channelCode)
                || Constants.CHN2046CODE.equals(channelCode)){
            return "021-52991228";
        }
        return "400-9200-108";
    }

    private String getPackageTitle(PackageSkuInfo skuInfo){
        return skuInfo.getCategoryName();
    }

    private UserInfo buildUserInfo(){
        UserInfo userInfo = new UserInfo();
        UUID uuid = UUID.randomUUID();
        userInfo.setLoginToken(uuid.toString());
        userInfo.setLoginIpAddress("172.17.17.154");
        return userInfo;
    }

    private boolean sendReqExFresh(ExFreshOrder order) throws IOException,HttpException{
        PostMethod method = new PostMethod(reqUrl);
        method.setRequestHeader("AppId",AppId);
        method.setRequestHeader("AppSecret",AppSecret);
        String json = JSONObject.toJSONString(order);
        RequestEntity entity = new StringRequestEntity(json,"application/json","UTF-8");
        method.setRequestEntity(entity);
        HttpClient client = new HttpClient();
        int status = client.executeMethod(method);
        if(status == HttpStatus.SC_OK){
            String str = method.getResponseBodyAsString();
            ExFreshResp resp = JSONObject.toJavaObject(JSONObject.parseObject(str),ExFreshResp.class);
            return resp.isSuccess();
        }
        return false;
    }


}
