/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.express;

import org.apache.commons.lang.StringUtils;

/**
 * @author Royan
 * @version $Id: PackageSkuInfo.java, v 0.1 2015-11-02 下午5:56
 */
public class PackageSkuInfo {

    /**
     * [code]name
     */
    private String skuName;
    /**
     * sku数量
     */
    private Double skuNum;
    /**
     * sku单价
     */
    private Double costPrice;
    /**
     * sku总价
     */
    private Double skuSum;

    /**
     * 是否 jit
     */
    private Integer isJit;
    /**
     * 品类名称
     */
    private String categoryName;

    private String level1CategoryName;
    
    /**
     * 品类code
     **/
    private String categoryCode;


    public String getSkuName() {
        if (StringUtils.isNotBlank(skuName)) {
            return skuName.replaceAll("[&'<>\\\\/]", " ");
        }
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Double getSkuNum() {
        return skuNum;
    }

    public String getLevel1CategoryName() {
        return level1CategoryName;
    }

    public void setLevel1CategoryName(String level1CategoryName) {
        this.level1CategoryName = level1CategoryName;
    }

    public void setSkuNum(Double skuNum) {
        this.skuNum = skuNum;
    }

    public Double getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(Double costPrice) {
        this.costPrice = costPrice;
    }

    public Double getSkuSum() {
        return skuSum;
    }

    public void setSkuSum(Double skuSum) {
        this.skuSum = skuSum;
    }

    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}
}