/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.email;

import com.thebeastshop.pegasus.integration.email.vo.EmailAttachmentVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.activation.DataHandler;
import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.util.ByteArrayDataSource;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Properties;

/**
 * @author Royan
 * @version $Id: SimpleMailSender.java, v 0.1 2015-07-10 下午2:01
 */
public class MailSender {

    private final Logger log = LoggerFactory.getLogger(MailSender.class);

    /**
     * 发送邮件
     *
     * @param mailInfo 待发送的邮件的信息
     */
    public boolean send(MailSenderInfo mailInfo) {
        // 判断是否需要身份认证
        MailAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            // 如果需要身份认证，则创建一个密码验证器
            authenticator = new MailAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        // 根据邮件会话属性和密码验证器构造一个发送邮件的session
        Session sendMailSession = Session.getDefaultInstance(pro, authenticator);
        try {
            // 根据session创建一个邮件消息
            Message mailMessage = new MimeMessage(sendMailSession);
            // 创建邮件发送者地址
            Address from = new InternetAddress(mailInfo.getFromAddress());
            // 设置邮件消息的发送者
            mailMessage.setFrom(from);
            // 创建邮件的接收者地址，并设置到邮件消息中
            Address[] tos = new Address[mailInfo.getToAddress().length];
            for (int i = 0; i < mailInfo.getToAddress().length; i++) {
                tos[i] = new InternetAddress(mailInfo.getToAddress()[i]);
            }
            mailMessage.setRecipients(Message.RecipientType.TO, tos);

            // 创建邮件的抄送者地址，并设置到邮件消息中
            if(mailInfo.getCopyTo() != null  && mailInfo.getCopyTo().length >0){
                Address[] copys = new Address[mailInfo.getCopyTo().length];
                for (int i = 0; i < mailInfo.getCopyTo().length; i++) {
                    copys[i] = new InternetAddress(mailInfo.getCopyTo()[i]);
                }
                mailMessage.addRecipients(Message.RecipientType.CC,copys);
            }


            // 设置邮件消息的主题
            mailMessage.setSubject(mailInfo.getSubject());
            // 设置邮件消息发送的时间
            mailMessage.setSentDate(new Date());
            // 设置邮件消息的主要内容
            String mailContent = mailInfo.getContent();


            // 新建一个MimeMultipart对象用来存放BodyPart对象
            MimeMultipart mm = new MimeMultipart();
            mailMessage.setContent(mm);

            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(mailContent, "text/html;charset=UTF-8");
            mm.addBodyPart(contentPart);

            // 附件
            List<EmailAttachmentVO> attachmentList = mailInfo.getAttachmentList();
            if (EmptyUtil.isNotEmpty(attachmentList)) {
                for (EmailAttachmentVO attachment : attachmentList) {
                    // 新建一个存放附件的BodyPart
                    BodyPart mdp = new MimeBodyPart();
                    DataHandler dh = new DataHandler(new ByteArrayDataSource(attachment.getBytes(),
                        "application/octet-stream"));
                    mdp.setDataHandler(dh);
                    // 加上这句将作为附件发送,否则将作为信件的文本内容
                    mdp.setFileName(MimeUtility.encodeText(attachment.getFileName()));
                    // 将含有附件的BodyPart加入到MimeMultipart对象中
                    mm.addBodyPart(mdp);
                }
            }

            // 发送邮件
            Transport.send(mailMessage);
            return true;
        } catch (MessagingException e) {
            log.warn("", e);
        } catch (UnsupportedEncodingException e) {
            log.warn("", e);
        }
        return false;
    }

}