/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.email;

import com.thebeastshop.pegasus.integration.email.vo.EmailSenderVO;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;

/**
 * @author Royan
 * @version $Id: EmailUtil.java, v 0.1 2015-08-13 下午6:42
 */
public class EmailUtil {

    private final Logger           log            = LoggerFactory.getLogger(EmailUtil.class);

    private static final EmailUtil instance       = new EmailUtil();

    private String                 mailServerHost = EmailProperties.getConfig("mailServerHost");

    private String                 mailServerPort = EmailProperties.getConfig("mailServerPort");

    private List<String>           senders        = Arrays.asList(EmailProperties.getConfig(
                                                      "senders").split(","));

    private MailSender             mailSender     = new MailSender();

    private EmailUtil() {
    }

    public static EmailUtil getInstance() {
        return instance;
    }

    public boolean send(EmailVO emailVO, EmailSenderVO emailSenderVO) {
        if (emailSenderVO == null) {
            return false;
        }

        if (EmptyUtil.isEmpty(emailVO.getToAddressList())) {
            return false;
        }

        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setMailServerHost(mailServerHost);
        mailInfo.setMailServerPort(mailServerPort);
        mailInfo.setValidate(true);
        mailInfo.setUserName(emailSenderVO.getUserName());
        mailInfo.setPassword(emailSenderVO.getPassword());
        mailInfo.setFromAddress(emailSenderVO.getUserName());
        mailInfo.setToAddress(emailVO.getToAddressList().toArray(new String[] {}));
        if(emailVO.getToCopyList() != null && emailVO.getToCopyList().size() > 0){
            mailInfo.setCopyTo(emailVO.getToCopyList().toArray(new String[] {}));
        }
        mailInfo.setSubject(emailVO.getSubject());
        mailInfo.setContent(emailVO.getContent());
        mailInfo.setAttachmentList(emailVO.getAttachmentList());

        return mailSender.send(mailInfo);
    }

    public boolean send(EmailVO emailVO) {
        return send(emailVO, findSender("webmaster"));
    }

    private EmailSenderVO findSender(String sender) {
        if (!senders.contains(sender)) {
            return null;
        }

        EmailSenderVO emailSenderVO = new EmailSenderVO();
        emailSenderVO.setUserName(EmailProperties.getConfig("sender." + sender + ".userName"));
        emailSenderVO.setPassword(EmailProperties.getConfig("sender." + sender + ".password"));
        return emailSenderVO;
    }

    //    public static void main(String[] args) throws Exception {
    //        EmailVO emailVO = new EmailVO();
    //        emailVO.setToAddressList(Arrays.asList(new String[] { "yuanchongyu1@163.com" }));
    //        emailVO.setSubject("222");
    //        emailVO.setContent("啊哦");
    //
    //        List<EmailAttachmentVO> attachmentList = new ArrayList<>();
    //        attachmentList.add(new EmailAttachmentVO("销售报表.xlsx", Files.readAllBytes(Paths
    //            .get("/Users/yuanchongyu/Desktop/report requirement.xlsx"))));
    //        emailVO.setAttachmentList(attachmentList);
    //
    //        boolean tf = EmailUtil.getInstance().send(emailVO);
    //        System.out.println(tf);
    //    }
}