/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.RedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;

public class ElementPool
implements Comparable<ElementPool> {
    private List<RedElement> eles;
    private Integer minEleCount;
    private Integer totalCount;
    private Integer maxPrice;
    private Integer minPrice;
    private Integer totalPrice;
    private Integer weight;

    public ElementPool() {
    }

    public ElementPool(ElementPool elementPool) {
        this.minEleCount = elementPool.getMinEleCount();
        this.totalCount = elementPool.getTotalCount();
        this.maxPrice = elementPool.getMaxPrice();
        this.minPrice = elementPool.getMinPrice();
        this.totalPrice = elementPool.getTotalPrice();
        this.weight = elementPool.getWeight();
    }

    public List<RedElement> getEles() {
        return this.eles;
    }

    public void setEles(List<RedElement> eles) {
        Collections.sort(eles);
        this.eles = eles;
    }

    public Integer getMinEleCount() {
        return this.minEleCount;
    }

    public void setMinEleCount(Integer minEleCount) {
        this.minEleCount = minEleCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getMaxPrice() {
        return this.maxPrice;
    }

    public void setMaxPrice(Integer maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Integer getMinPrice() {
        return this.minPrice;
    }

    public void setMinPrice(Integer minPrice) {
        this.minPrice = minPrice;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getTotalPrice() {
        if (CollectionUtils.isNotEmpty(this.eles)) {
            this.totalPrice = 0;
            for (RedElement redElement : this.eles) {
                this.totalPrice = this.totalPrice + redElement.getValue() * redElement.getNum();
            }
        }
        return this.totalPrice;
    }

    public void setTotalPrice(Integer totalPrice) {
        this.totalPrice = totalPrice;
    }

    @Override
    public int compareTo(ElementPool o) {
        if (this.weight > o.weight) {
            return 1;
        }
        if (this.weight < o.weight) {
            return -1;
        }
        return 0;
    }

    public ElementPool getRandomElements() {
        ElementPool elementPool = new ElementPool(this);
        ArrayList list = Lists.newArrayList();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        do {
            map.clear();
            for (int i = 0; i < this.totalCount; ++i) {
                int idx = new Random().nextInt(this.eles.size());
                if (null == map.get(idx)) {
                    map.put(idx, 1);
                    continue;
                }
                map.put(idx, (Integer)map.get(idx) + 1);
            }
        } while (map.size() < this.minEleCount);
        for (Map.Entry entry : map.entrySet()) {
            this.eles.get((Integer)entry.getKey());
            RedElement redElement = new RedElement(this.eles.get((Integer)entry.getKey()));
            redElement.setNum((Integer)entry.getValue());
            list.add(redElement);
        }
        elementPool.setEles(list);
        return elementPool;
    }
}

