package com.thebeastshop.pegasus.component.time.support;

import com.thebeastshop.pegasus.component.time.TimeSlot;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * @author Liang Wenjian
 */
public class DefaultTimeSlotImpl implements TimeSlot {
	private Integer id;
	private Date start;
	private Date end;

	@Override
	public Integer getId() {
		return id;
	}

	public void setId(final Integer id) {
		this.id = id;
	}

	@Override
	public Date getStart() {
		return start;
	}

	public void setStart(final Date start) {
		this.start = start;
	}

	@Override
	public Date getEnd() {
		return end;
	}

	public void setEnd(final Date end) {
		this.end = end;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof TimeSlot)) {
			return false;
		}
		final TimeSlot that = (TimeSlot) o;
		return Objects.equals(getId(), that.getId());
	}

	@Override
	public int hashCode() {
		return Objects.hash(getId());
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + hashCode() + ":{" + "id:" + id + ", start:" + start + ", end:" + end + '}';
	}

	@Override
	public String getText() {
		SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
		return dateFormat.format(getStart()) + " - " + dateFormat.format(getEnd());
	}

}
