package com.thebeastshop.pegasus.component.time.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.time.TimeSlot;
import com.thebeastshop.pegasus.component.time.TimeSlotType;
import com.thebeastshop.pegasus.component.time.service.TimeSlotService;
import com.thebeastshop.pegasus.component.time.support.DefaultTimeSlotImpl;

/**
 * @author Liang Wenjian
 */
@Service
public class TimeSlotServiceImpl implements TimeSlotService {

	public TimeSlotServiceImpl() {
		super();
	}

	@Override
	public TimeSlot getById(final int id) {
		final List<TimeSlot> list = getByType(TimeSlotType.DELIVERY_TIME);
		final int index = id - 1;
		if (index < 0 || index >= list.size()) {
			return null;
		}
		return list.get(index);
	}

	@Override
	public List<TimeSlot> getByType(final TimeSlotType type) {
		final List<TimeSlot> rt = Lists.newArrayList();
		if (type == TimeSlotType.DELIVERY_TIME) {
			final Calendar c = Calendar.getInstance();
			c.set(Calendar.MINUTE, 0);
			c.set(Calendar.SECOND, 0);
			{// 11:00:00~14:00:00
				c.set(Calendar.HOUR_OF_DAY, 11);
				final Date start = c.getTime();
				c.set(Calendar.HOUR_OF_DAY, 14);
				final Date end = c.getTime();
				final DefaultTimeSlotImpl slot = new DefaultTimeSlotImpl();
				slot.setId(1);
				slot.setStart(start);
				slot.setEnd(end);
				rt.add(slot);
			}
			{// 14:00~17:00？
				c.set(Calendar.HOUR_OF_DAY, 14);
				final Date start = c.getTime();
				c.set(Calendar.HOUR_OF_DAY, 17);
				final Date end = c.getTime();
				final DefaultTimeSlotImpl slot = new DefaultTimeSlotImpl();
				slot.setId(2);
				slot.setStart(start);
				slot.setEnd(end);
				rt.add(slot);
			}
			{// 17:00-20:00
				c.set(Calendar.HOUR_OF_DAY, 17);
				final Date start = c.getTime();
				c.set(Calendar.HOUR_OF_DAY, 20);
				final Date end = c.getTime();
				final DefaultTimeSlotImpl slot = new DefaultTimeSlotImpl();
				slot.setId(3);
				slot.setStart(start);
				slot.setEnd(end);
				rt.add(slot);
			}
		}
		return rt;
	}

	@Override
	public List<TimeSlot> getAll() {
		return getByType(TimeSlotType.DELIVERY_TIME);
	}

}
