package com.thebeastshop.pegasus.component.support.service;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/**
 * redis service
 * 
 * @author Paul-xiong
 *
 */
public interface RedisService {

	public String get(String key);

	public <T> T get(String key, Type clazz);

	public void set(String key, String value);

	public <T> void set(String key, T value);

	public void set(String key, String value, int seconds);

	public <T> void set(String key, T value, int seconds);

	public boolean exists(String key);

	public void del(String key);

	public Long incr(String key);

	public Long decr(String key);

	public Long lpush(String key, String... values);

	public List<String> lrange(String key);

	/**
	 * 批量删除keys
	 * 
	 * @param keyPattern
	 */
	public void delsBykeyPattern(String keyPattern);

	/**
	 * 设置过期时间
	 * 
	 * @param key
	 * @param seconds
	 * @return
	 */
	public void expire(String key, Integer seconds);

	void hmset(String key, Map<String, String> hash, int second);

	List<String> hmget(String key, String... fields);

	Map<String, String> getAll(String key);

}
