package com.thebeastshop.pegasus.component.support.config;

import org.springframework.beans.factory.annotation.Autowired;

public class RedisConfig {
	@Autowired
	private static PropertyConfigurer configurer;

	public static String getHost() {
		String str = "";
		if (configurer != null) {
			str = configurer.getProperty("redis.host");
		}
		return str;
	}

	public static int getPort() {
		int port = 0;
		if (configurer != null) {
			port = Integer.parseInt(configurer.getProperty("redis.port"));
		}
		return port;
	}

	public static Integer getMaxIdle() {
		if (configurer != null) {
			return Integer.parseInt(configurer.getProperty("redis.pool.maxIdle"));
		}
		return null;
	}

	public static Integer getMaxActive() {
		if (configurer != null) {
			return Integer.parseInt(configurer.getProperty("redis.pool.maxActive"));
		}
		return null;
	}

	public static Integer getMaxWait() {
		if (configurer != null) {
			return Integer.parseInt(configurer.getProperty("redis.pool.maxWait"));
		}
		return null;
	}

}
