package com.thebeastshop.pegasus.component.support.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.stereotype.Component;
@Component
public class PropertyConfigurer extends PropertyPlaceholderConfigurer {

	private final static Logger log = LoggerFactory.getLogger(PropertyConfigurer.class);
	private Properties props;


	@Override
	protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
		super.processProperties(beanFactoryToProcess, props);
		this.props = props;
	}

	public String getProperty(String key) {
		return props.getProperty(key);
	}
	
	public String getProperty(String key, String defaultValue) {
		return props.getProperty(key, defaultValue);
	}
	
	public Object setProperty(String key, String value) {
		return props.setProperty(key, value);
	}

	public String getEzrBaseUrl() {
		String ret = getProperty("constants.ezr.baseUrl");
		log.info("【GET PROPERTY】constants.ezr.baseUrl = {}", ret);
		return ret;
	}

	public String getEzrAppID() {
		String ret = getProperty("constants.ezr.app.id");
		return ret;
	}

	public String getEzrToken() {
		String ret =  getProperty("constants.ezr.token");
		return ret;
	}

	public String getEzrAppSystem() {
		String ret =  getProperty("constants.ezr.app.system");
		return ret;
	}

	public String getChannelServiceURL() {
		String ret =  getProperty("constants.cs_url");
		return ret;
	}

	public String getEzrServiceUrl() {
		String ret = getProperty("constants.ezr.outsite");
		return ret;
	}

	public Map<String, String> getHttpParamMap() {
		Map<String, String> paramMap = new HashMap<>();
		paramMap.put("appId", getEzrAppID());
		paramMap.put("token", getEzrToken());
		paramMap.put("appSystem", getEzrAppSystem());
		return paramMap;
	}

}
