package com.thebeastshop.pegasus.component.shop.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.thebeastshop.pegasus.component.index.domain.Index;
import com.thebeastshop.pegasus.component.index.service.IndexEntryService;
import com.thebeastshop.pegasus.component.shop.domain.OpShopOperation;

/**
 * 预发布判断
 * 
 * @author Yawei.Wang
 *
 */
@Component
@Aspect
public class OperationPrepublish {

	protected Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private ShopEntryService service;

	@Autowired
	private IndexEntryService indexService;

	public OperationPrepublish() {
		super();
	}

	/**
	 * 店铺预发时间判断并发布
	 */
	@Before(value = "execution(* com.thebeastshop.pegasus.component.shop.service.impl.*.findOperationListByCond(..))")
	public void prePublish() {
		logger.info("prePublish");
		try {
			// 查找所有预发布内容
			OpShopOperation cond = new OpShopOperation();
			cond.setState(3);
			List<OpShopOperation> ops = new ArrayList<OpShopOperation>();
			ops = service.findOperationByCond(cond);
			if (null != ops && ops.size() > 0) {
				for (OpShopOperation op : ops) {
					Date pre = op.getPublishTime();
					Date cur = Calendar.getInstance().getTime();
					if (pre.before(cur)) {
						// 查找线上数据并下线
						OpShopOperation cond1 = new OpShopOperation();
						cond1.setState(1);
						cond1.setShopId(op.getShopId());
						List<OpShopOperation> records = new ArrayList<OpShopOperation>();
						records = service.findOperationByCond(cond1);
						if (null != records && records.size() > 0) {
							for (OpShopOperation record : records) {
								record.setState(2);
								service.operationUpdateByPrimaryKeySelective(record);
							}
						}
						// 预发上线
						op.setState(1);
						service.operationUpdateByPrimaryKeySelective(op);
					}
				}
			}
		} catch (Exception e) {
			logger.info("预约发布异常 e:{}", e);
		}
	}

	/**
	 * 首页预发时间判断并发布
	 */
	@Before(value = "execution(* com.thebeastshop.pegasus.component.index.service.impl.*.findIndexListByCond(..))")
	public void preIndexPublish() {
		logger.info("prePublish");
		try {
			// 查找所有预发布内容
			Index cond = new Index();
			cond.setState(3);
			List<Index> indexs = new ArrayList<Index>();
			indexs = indexService.findIndexLists(cond);
			if (null != indexs && indexs.size() > 0) {
				for (Index index : indexs) {
					Date pre = index.getPublishTime();
					Date cur = Calendar.getInstance().getTime();
					if (pre.before(cur)) {
						// 查找线上数据并下线
						List<Index> records = new ArrayList<Index>();
						Index cond1 = new Index();
						cond1.setState(1);
						records = indexService.findIndexLists(cond1);
						if (null != records && records.size() > 0) {
							for (Index record : records) {
								record.setState(2);
								indexService.updateByPrimaryKeySelective(record);
							}
						}
						// 预发上线
						index.setState(1);
						indexService.updateByPrimaryKeySelective(index);
					}
				}
			}
		} catch (Exception e) {
			logger.info("预约发布异常 e:{}", e);
		}
	}
}
