package com.thebeastshop.pegasus.component.shop.dao.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.thebeastshop.pegasus.component.shop.dao.ShopEntryDao;
import com.thebeastshop.pegasus.component.shop.dao.mapper.BubbleMapper;
import com.thebeastshop.pegasus.component.shop.dao.mapper.ShopEntryMapper;
import com.thebeastshop.pegasus.component.shop.domain.BubbleVo;
import com.thebeastshop.pegasus.component.shop.domain.OpShopOperation;
import com.thebeastshop.pegasus.component.shop.domain.ShopEntry;
import com.thebeastshop.pegasus.component.shop.domain.ShopEntryExample;
import com.thebeastshop.pegasus.component.shop.domain.ShopVo;

@Repository
public class ShopEntryDaoImpl implements ShopEntryDao {
	
	@Autowired
	private ShopEntryMapper mapper;
	
	@Autowired
	private BubbleMapper bubmapper;

	@Override
	public int countByExample(ShopEntryExample example) {
		return mapper.countByExample(example);
	}

	@Override
	public int deleteByExample(ShopEntryExample example) {
		return mapper.deleteByExample(example);
	}

	@Override
	public int deleteByPrimaryKey(Long id) {
		return mapper.deleteByPrimaryKey(id);
	}

	@Override
	public int insert(ShopEntry record) {
		return mapper.insert(record);
	}

	@Override
	public int insertSelective(ShopEntry record) {
		return mapper.insert(record);
	}

	@Override
	public List<ShopEntry> selectByExample(ShopEntryExample example) {
		return mapper.selectByExample(example);
	}

	@Override
	public ShopEntry selectByPrimaryKey(Long id) {
		return mapper.selectByPrimaryKey(id);
	}

	@Override
	public int updateByExampleSelective(ShopEntry record,
			ShopEntryExample example) {
		return mapper.updateByExampleSelective(record, example);
	}

	@Override
	public int updateByExample(ShopEntry record, ShopEntryExample example) {
		return mapper.updateByExample(record, example);
	}

	@Override
	public int updateByPrimaryKeySelective(ShopEntry record) {
		return mapper.updateByPrimaryKeySelective(record);
	}

	@Override
	public int updateByPrimaryKey(ShopEntry record) {
		return mapper.updateByPrimaryKey(record);
	}

	public ShopEntryMapper getMapper() {
		return mapper;
	}

	public void setMapper(ShopEntryMapper mapper) {
		this.mapper = mapper;
	}

	@Override
	public List<ShopVo> findOperationListByCond(ShopVo cond) {
		// TODO Auto-generated method stub
		return mapper.findOperationListByCond(cond);
	}
	
	@Override
	public List<BubbleVo> findBubbleByCond(BubbleVo cond) {
		// TODO Auto-generated method stub
		return bubmapper.findBubbleByCond(cond);
	}
	
	@Override
	public List<OpShopOperation> findOperationByCond(OpShopOperation cond) {
		// TODO Auto-generated method stub
		return mapper.findOperationByCond(cond);
	}
	
	@Override
	public int operationUpdateByPrimaryKeySelective(OpShopOperation record) {
		return mapper.operationUpdateByPrimaryKeySelective(record);
	}

	
}
