package com.thebeastshop.pegasus.component.shop;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import com.thebeastshop.pegasus.component.shop.domain.BubbleVo;
import com.thebeastshop.pegasus.component.shop.domain.OpShopOperation;
import com.thebeastshop.pegasus.component.shop.domain.ShopEntry;
import com.thebeastshop.pegasus.component.shop.domain.ShopEntryExample;
import com.thebeastshop.pegasus.component.shop.domain.ShopVo;
import com.thebeastshop.pegasus.component.shop.service.ShopEntryService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;

public class PegasusShopServiceFacade {

	private static PegasusShopServiceFacade instance;

	@Autowired
	private ShopEntryService shopService;

	// ==============华丽丽的分割线==============

	public static PegasusShopServiceFacade getInstance() {
		if (instance != null) {
			return instance;
		}

		synchronized (PegasusFacadeLock.class) {
			if (instance == null) {
				instance = ComponentServiceLoader
						.getBean(PegasusShopServiceFacade.class);
			}
		}
		return instance;
	}

	public int countByExample(ShopEntryExample example) {
		// TODO Auto-generated method stub
		return shopService.countByExample(example);
	}

	public int deleteByExample(ShopEntryExample example) {
		// TODO Auto-generated method stub
		return shopService.deleteByExample(example);
	}

	public int deleteByPrimaryKey(Long id) {
		// TODO Auto-generated method stub
		return shopService.deleteByPrimaryKey(id);
	}

	public int insert(ShopEntry record) {
		// TODO Auto-generated method stub
		return shopService.insert(record);
	}

	public int insertSelective(ShopEntry record) {
		// TODO Auto-generated method stub
		return shopService.insert(record);
	}

	public List<ShopEntry> selectByExample(ShopEntryExample example) {
		// TODO Auto-generated method stub
		return shopService.selectByExample(example);
	}

	public ShopEntry selectByPrimaryKey(Long id) {
		// TODO Auto-generated method stub
		return shopService.selectByPrimaryKey(id);
	}

	public int updateByExampleSelective(ShopEntry record,
			ShopEntryExample example) {
		// TODO Auto-generated method stub
		return shopService.updateByExampleSelective(record, example);
	}

	public int updateByExample(ShopEntry record, ShopEntryExample example) {
		// TODO Auto-generated method stub
		return shopService.updateByExample(record, example);
	}

	public int updateByPrimaryKeySelective(ShopEntry record) {
		// TODO Auto-generated method stub
		return shopService.updateByPrimaryKeySelective(record);
	}

	public int updateByPrimaryKey(ShopEntry record) {
		// TODO Auto-generated method stub
		return shopService.updateByPrimaryKey(record);
	}

	public List<ShopVo> findOperationListByCond(ShopVo cond) {
		// TODO Auto-generated method stub

		return shopService.findOperationListByCond(cond);
	}

	public List<BubbleVo> findBubbleByCond(BubbleVo cond) {
		// TODO Auto-generated method stub
		return shopService.findBubbleByCond(cond);
	}

	public List<OpShopOperation> findOperationByCond(OpShopOperation cond) {
		// TODO Auto-generated method stub
		return shopService.findOperationByCond(cond);
	}

	public int operationUpdateByPrimaryKeySelective(OpShopOperation record) {
		// TODO Auto-generated method stub
		return shopService.operationUpdateByPrimaryKeySelective(record);
	}

}
