package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;
import com.thebeastshop.support.vo.redenvelope.RedPrize;
import com.thebeastshop.support.vo.redenvelope.RedPrizePool;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分档红包：
 * 红包池分为不同档次：
 * 每个档次确认获取数量 和种类
 * 设置红包总数 和总金额
 * Created by feilong.gao on 2017/3/30.
 */
public class SeparateRedUtil {

    /**
     * 总金额
     */
    private static Integer totalCutPrice = 400;

    /**
     * 总数
     */
    private static Integer totalNum = 20;

    /**
     * 红包池
     */
    private static List<ElementPool> elementPools;

    private static Map<String,RedPrize> prizeMap;

    private static Integer poolSize = 3;

    private static void init(RedEnvelopeConfig redEnvelopeConfig){
        totalCutPrice = redEnvelopeConfig.getTotalCutPrice();
        totalNum = redEnvelopeConfig.getRedTotalNum();
        List<RedPrizePool> redPools = redEnvelopeConfig.getRedPoolGroup();
        elementPools =getElementPools(redPools);
        setBoundary();
    }

    /**
     * 奖品转成元素
     * @param redPools
     * @return
     */
    private static List<ElementPool> getElementPools(List<RedPrizePool> redPools){
        if(null == prizeMap){
            prizeMap = new HashMap<>();
        }
        List<ElementPool> result = Lists.newArrayList();
        for(RedPrizePool redPrizePool : redPools){
            ElementPool elementPool = new ElementPool();
            elementPool.setMinEleCount(redPrizePool.getMinEleCount());
            elementPool.setTotalCount(redPrizePool.getTotalCount());
            List<RedPrize> redPrizes = redPrizePool.getEles();
            List<RedElement> eles = Lists.newArrayList();
            for(RedPrize redPrize : redPrizes){
                eles.add(new RedElement(redPrize.getRedValue(),redPrize.getCutPrice()));
                prizeMap.put(redPrize.getRedValue(),redPrize);
            }
            elementPool.setEles(eles);
            result.add(elementPool);
        }
        return result;

    }

    public static List<ElementPool> initElementPool() {
        // 设置第一档
        ElementPool ep1 = new ElementPool();
        ep1.setMinEleCount(3);
        ep1.setTotalCount(16);
        List<RedElement> list = Lists.newArrayList(
                new RedElement("满300减10", 10),
                new RedElement("满300减11", 11),
                new RedElement("满300减12", 12),
                new RedElement("满300减15", 15),
                new RedElement("满300减16", 16),
                new RedElement("满300减17", 17),
                new RedElement("满300减18", 18),
                new RedElement("满300减19", 19),
                new RedElement("满300减20", 20),
                new RedElement("满300减21", 21),
                new RedElement("满300减22", 22),
                new RedElement("满300减23", 23),
                new RedElement("满300减25", 25),
                new RedElement("满300减26", 26),
                new RedElement("满300减27", 27),
                new RedElement("满300减28", 28),
                new RedElement("满300减29", 29));
        ep1.setEles(list);


        // 设置第二档
        ElementPool ep2 = new ElementPool();
        ep2.setMinEleCount(1);
        ep2.setTotalCount(3);
        List<RedElement> list2 = Lists.newArrayList(
                new RedElement("满500减30", 30),
                new RedElement("满500减35", 35),
                new RedElement("满500减40", 40),
                new RedElement("满500减45", 45));
        ep2.setEles(list2);

        // 设置第三档
        ElementPool ep3 = new ElementPool();
        ep3.setMinEleCount(1);
        ep3.setTotalCount(1);
        List<RedElement> list3 = Lists.newArrayList(
                new RedElement("满800减60", 60),
                new RedElement("满800减80", 80),
                new RedElement("满1200减100", 100),
                new RedElement("满1200减120", 120));
        ep3.setEles(list3);

        elementPools = Lists.newArrayList();
        elementPools.add(ep1);
        elementPools.add(ep2);
        elementPools.add(ep3);
        return elementPools;
    }

    // 1、计算各挡的边界
    private static void setBoundary() {
        if (CollectionUtils.isNotEmpty(elementPools)) {
            for (ElementPool elementPool : elementPools) {
                setBundaryPrice(elementPool);
            }
            Collections.sort(elementPools);
            ElementPool ep1 = elementPools.get(0);
            ElementPool ep2 = elementPools.get(1);
            ElementPool ep3 = elementPools.get(2);
            // 设置ep2 边界值
            int ep2minPrice = totalCutPrice - ep1.getMaxPrice() - ep3.getMaxPrice();
            if (ep2minPrice > ep2.getMinPrice()) {
                ep2.setMinPrice(ep2minPrice);
            }
            int ep2maxPrice = totalCutPrice - ep1.getMinPrice() - ep3.getMinPrice();
            if (ep2maxPrice < ep2.getMaxPrice()) {
                ep2.setMaxPrice(ep2maxPrice);
            }

            // 设置ep3 边界值
            int ep3minPrice = totalCutPrice - ep1.getMaxPrice() - ep2.getMaxPrice();
            if (ep3minPrice > ep3.getMinPrice()) {
                ep3.setMinPrice(ep3minPrice);
            }
            int ep3maxPrice = totalCutPrice - ep1.getMinPrice() - ep2.getMinPrice();
            if (ep3maxPrice < ep3.getMaxPrice()) {
                ep3.setMaxPrice(ep3maxPrice);
            }


        }

    }


    /**
     * 设置边界值
     * @param elementPool
     */
    private static void setBundaryPrice(ElementPool elementPool) {
        int maxPrice = 0;
        int minPrice = 0;
        int minEle = elementPool.getMinEleCount();
        int totalEle = elementPool.getTotalCount();
        List<RedElement> eles = elementPool.getEles();
        if (CollectionUtils.isNotEmpty(eles)) {
            maxPrice = eles.get(0).getValue() * (totalEle - minEle);
            minPrice = eles.get(eles.size() - 1).getValue() * (totalEle - minEle);
            for (int i = 0; i < minEle; i++) {
                maxPrice += eles.get(i).getValue();
                minPrice += eles.get(eles.size() - 1 - i).getValue();
            }
        }
        elementPool.setMaxPrice(maxPrice);
        elementPool.setMinPrice(minPrice);

        setWeight(elementPool);
    }

    // 设置权重
    private static void setWeight(ElementPool elementPool) {
        int weight = elementPool.getEles().size() * elementPool.getTotalCount();
        elementPool.setWeight(weight);
    }

    public static List<ElementPool> getRedEles() {
        // 1、抽取第一挡红包
        ElementPool ep1 = elementPools.get(0).getRandomElements();
        // 2、 计算第二挡红包的限制
        elementPools.get(0).getMaxPrice();
        ElementPool ep2 = null;
        int surplusAmount = 0;
        do {
            ep2 = elementPools.get(1).getRandomElements();
            surplusAmount = totalCutPrice - ep1.getTotalPrice() - ep2.getTotalPrice();
        }
        while (surplusAmount > elementPools.get(2).getMaxPrice() || surplusAmount < elementPools.get(2).getMinPrice());

        PutTogetherUtil putTogetherUtil = new PutTogetherUtil();
        putTogetherUtil.init(elementPools.get(2));
        ElementPool ep3 = putTogetherUtil.putTogether(elementPools.get(2), surplusAmount);
        List<ElementPool> result = Lists.newArrayList(ep1, ep2, ep3);
        return result;

    }


    /**
     * 获取分档红包配置
     * @param redEnvelopeConfig
     * @return
     */
    public static RedEnvelopeConfig getSeparateRedConfig(RedEnvelopeConfig redEnvelopeConfig){
        init(redEnvelopeConfig);
        List<ElementPool> result = getRedEles();
        List<RedPrize> list = Lists.newArrayList();
        for(ElementPool elementPool : result){
            for(RedElement redElement :elementPool.getEles()){
                RedPrize redPrize =prizeMap.get(redElement.getName());
                redPrize.setNum(redElement.getNum());
                list.add(redPrize);
            }
        }
        redEnvelopeConfig.setRedGroup(list);
        return redEnvelopeConfig;
    }

    public static void main(String[] args) {
        initElementPool();
        Gson gson = new GsonBuilder().create();
        System.out.println("==========================step1 设置边界======>");
        setBoundary();
        System.out.println(gson.toJson(elementPools));
        System.out.println("==========================step3  抽取红包======>");
        List<ElementPool> result = getRedEles();
        System.out.println("===========生成红包 =======>");
        System.out.println(gson.toJson(result));
        System.out.println("====================end =======>");


    }

}
