package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;
import com.thebeastshop.support.vo.redenvelope.RedPrize;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Random;

/**
 * Created by feilong.gao on 2017/3/31.
 */
public class DivideRedUtil {

    /**
     * 红包数量分组
     */
    private static List<List<Integer>> groups = Lists.newArrayList();

    /**
     * 红包对应数量限制
     */
    private static List<Integer> redNumLimit = null;


    /**
     * 初始化红包数量限制
     *
     * @param redConfig
     */
    private void initRedNumLimit(RedConfig redConfig) {
        redNumLimit = Lists.newArrayListWithCapacity(redConfig.getRedElementList().size());
        List<RedElement> redElements = redConfig.getRedElementList();
        Integer a = 0;
        for (RedElement redElement : redElements) {
            a += redElement.getValue();
        }
        for (RedElement redElement : redElements) {
            redNumLimit.add((redConfig.getTotalCount() - a) / redElement.getValue() + 1);
        }
    }

    /**
     * 初始化红包数量限制
     *
     * @param redEnvelopeConfig
     */
    private static void initRedNumLimit(RedEnvelopeConfig redEnvelopeConfig) {
        redNumLimit = Lists.newArrayListWithCapacity(redEnvelopeConfig.getRedGroup().size());
        List<RedPrize> redElements = redEnvelopeConfig.getRedGroup();
        Integer a = 0;
        for (RedPrize prize : redElements) {
            a += prize.getCutPrice();
        }
        for (RedPrize redElement : redElements) {
            redNumLimit.add((redEnvelopeConfig.getTotalCutPrice() - a) / redElement.getCutPrice() + 1);
        }
    }


    /**
     * 划分红包
     * @param redConifg
     * @return
     */
    public List<List<Integer>> divideRed(RedConfig redConifg) {
        initRedNumLimit(redConifg);
        split(null, redConifg.getTotalNum(), redConifg.getRedElementList().size());
        List<List<Integer>> redGroups = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(groups)) {
            for (List<Integer> r : groups) {
                if (CollectionUtils.isNotEmpty(r)) {
                    int b = 0;
                    for (int i = 0; i < redConifg.getRedElementList().size(); i++) {
                        b += r.get(i) * redConifg.getRedElementList().get(i).getValue();
                    }
                    if (b == redConifg.getTotalCount()) {
                        redGroups.add(r);
                    }
                }
            }
        }
        return redGroups;
    }

    /**
     * 生成随机红包配置信息
     * @param config
     * @return
     */
    public static RedEnvelopeConfig randomRedEnvelopeConfig(RedEnvelopeConfig config){
        initRedNumLimit(config);
        int m = config.getRedTotalNum();
        int n = config.getRedGroup().size();
        split(null,m,n);
        List<List<Integer>> redGroups = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(groups)) {
            for (List<Integer> r : groups) {
                if (CollectionUtils.isNotEmpty(r)) {
                    Integer b = 0;
                    for (int i = 0; i < n; i++) {
                        b += r.get(i) *config.getRedGroup().get(i).getCutPrice();
                    }
                    if (b.equals(config.getTotalCutPrice())) {
                        redGroups.add(r);
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(redGroups)){
            int max = redGroups.size();
            int idx =0;
            if(max>1){
                idx = new Random().nextInt(max);
            }
            List<Integer> prizeNums = redGroups.get(idx);
            for (int i = 0; i < n; i++) {
                config.getRedGroup().get(i).setNum(prizeNums.get(i));
            }
        }

        return config;
    }

    /**
     * M划分N份
     *
     * @param m
     * @param n
     */
    private static int split(List<Integer> s, int m, int n) {
        List<Integer> locs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(s)) {
            locs = Lists.newCopyOnWriteArrayList(s);
        }
        if (m < n) {
            return 1;
        }
        if (n == 1) {
            List<Integer> add = Lists.newCopyOnWriteArrayList(locs);
            add.add(m);
            groups.add(add);
            return 1;
        }
        if (m == n) {
            List<Integer> add = Lists.newCopyOnWriteArrayList(locs);
            for (int i = 1; i <= n; i++) {
                add.add(1);
            }
            groups.add(add);
            return 1;
        }
        if (m > n) {
            int a = m - n + 1;
            for (int i = 1; i <= a; i++) {
                List<Integer> add = Lists.newCopyOnWriteArrayList(locs);
                add.add(i);
                split(add, m - i, n - 1);
//                if (i <= redNumLimit.get(redNumLimit.size()-n + 1)) {    // 限制红包最大个数，减少不必要的运算
//                }
            }
        }
        return 0;
    }
}
