package com.thebeastshop.pegasus.component.redenvelope.util;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.DivideRedUtil;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.SeparateRedUtil;
import com.thebeastshop.support.enums.RedEnvelopeTemplateType;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;
import com.thebeastshop.support.vo.redenvelope.RedPrize;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Random;

/**
 * 红包数量划分
 * Created by feilong.gao on 2017/2/10.
 */
public class RedEnveloperDivideUtil {

    /**
     * 生成随机红包配置信息
     * @param config
     * @return
     */
    public static RedEnvelopeConfig randomRedEnvelopeConfig(RedEnvelopeConfig config){
        RedEnvelopeConfig result = null;
        if(RedEnvelopeTemplateType.RANDOM_SEPARATE_TEMPLATE.getCode().equals(config.getTemplateType())){
            result = SeparateRedUtil.getSeparateRedConfig(config);
        }else{
            result = DivideRedUtil.randomRedEnvelopeConfig(config);
        }
        return result;

    }


}