package com.thebeastshop.pegasus.component.redenvelope.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.redenvelope.dao.mapper.RedEnvelopePrizeGroupMapper;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopePrizeGroup;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopePrizeGroupExample;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopePrizeGroupService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by feilong.gao on 2017/2/13.
 */
@Service
public class RedEnvelopePrizeGroupServiceImpl implements RedEnvelopePrizeGroupService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedEnvelopePrizeGroupMapper mapper;

    @Override
    public Boolean addRedEnvelopePrizeGroup(List<RedEnvelopePrizeGroup> prizeGroups) {

        if(CollectionUtils.isNotEmpty(prizeGroups)){
            for(RedEnvelopePrizeGroup prize : prizeGroups){
                mapper.insert(prize);
            }
        }
        return null;
    }

    public Boolean updateStock(Long id){
        logger.info("更新分享活动id[{}]的红包库存", id);
        RedEnvelopePrizeGroup old = mapper.selectByPrimaryKey(id);
        if (old != null && old.getReleasedCount() < old.getReAmount()) {
            logger.info("id[{}]库存记录：{}", JSON.toJSONString(old));
            RedEnvelopePrizeGroup upd = new RedEnvelopePrizeGroup();
            upd.setReleasedCount(old.getReleasedCount() + 1);
            upd.setModifyTime(new Date());
            RedEnvelopePrizeGroupExample redEnvelopeExample = new RedEnvelopePrizeGroupExample();
            redEnvelopeExample.createCriteria().andIdEqualTo(id)
                    .andReleasedCountLessThan(old.getReAmount());
            int num = mapper.updateByExampleSelective(upd, redEnvelopeExample);
            logger.info("更新id[{}]的红包库存，结果：", num == 1);
            if (num == 1) {
                return true;
            }
        } else {
            logger.warn("id[{}]库存记录为空", id);
        }
        return false;
    }



    @Override
    public List<RedEnvelopePrizeGroup> getPrizeGroupByActiveId(Long activityId) {
        logger.info("获取分享活动id[{}]的红包奖品组合", activityId);
        RedEnvelopePrizeGroupExample example = new RedEnvelopePrizeGroupExample();
        example.createCriteria().andActivityIdEqualTo(activityId);
        List<RedEnvelopePrizeGroup> prizeGroups = mapper.selectByExample(example);
        return prizeGroups;
    }
}
